@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin.inputs

import com.pulumi.azurenative.standbypool.inputs.StandbyVirtualMachinePoolElasticityProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details of the elasticity profile.
 * @property maxReadyCapacity Specifies the maximum number of virtual machines in the standby virtual machine pool.
 */
public data class StandbyVirtualMachinePoolElasticityProfileArgs(
    public val maxReadyCapacity: Output<Double>,
) :
    ConvertibleToJava<com.pulumi.azurenative.standbypool.inputs.StandbyVirtualMachinePoolElasticityProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.standbypool.inputs.StandbyVirtualMachinePoolElasticityProfileArgs =
        com.pulumi.azurenative.standbypool.inputs.StandbyVirtualMachinePoolElasticityProfileArgs.builder()
            .maxReadyCapacity(maxReadyCapacity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StandbyVirtualMachinePoolElasticityProfileArgs].
 */
@PulumiTagMarker
public class StandbyVirtualMachinePoolElasticityProfileArgsBuilder internal constructor() {
    private var maxReadyCapacity: Output<Double>? = null

    /**
     * @param value Specifies the maximum number of virtual machines in the standby virtual machine pool.
     */
    @JvmName("aofikxsebvkxgdap")
    public suspend fun maxReadyCapacity(`value`: Output<Double>) {
        this.maxReadyCapacity = value
    }

    /**
     * @param value Specifies the maximum number of virtual machines in the standby virtual machine pool.
     */
    @JvmName("lksuilhajglrqjgn")
    public suspend fun maxReadyCapacity(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxReadyCapacity = mapped
    }

    internal fun build(): StandbyVirtualMachinePoolElasticityProfileArgs =
        StandbyVirtualMachinePoolElasticityProfileArgs(
            maxReadyCapacity = maxReadyCapacity ?: throw PulumiNullFieldException("maxReadyCapacity"),
        )
}
