@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.kotlin.enums.BlobAccessTier
import com.pulumi.azurenative.storage.kotlin.enums.BlobType
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.storage.kotlin.enums.BlobAccessTier.Companion.toKotlin as blobAccessTierToKotlin
import com.pulumi.azurenative.storage.kotlin.enums.BlobType.Companion.toKotlin as blobTypeToKotlin

/**
 * Builder for [Blob].
 */
@PulumiTagMarker
public class BlobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BlobArgs = BlobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BlobArgsBuilder.() -> Unit) {
        val builder = BlobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Blob {
        val builtJavaResource = com.pulumi.azurenative.storage.Blob(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Blob(builtJavaResource)
    }
}

/**
 * Manages a Blob within a Storage Container.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:Blob myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/blobs/{blobName}
 * ```
 */
public class Blob internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.Blob,
) : KotlinCustomResource(javaResource, BlobMapper) {
    /**
     * The access tier of the storage blob.
     */
    public val accessTier: Output<BlobAccessTier>
        get() = javaResource.accessTier().applyValue({ args0 ->
            args0.let({ args0 ->
                blobAccessTierToKotlin(args0)
            })
        })

    /**
     * The MD5 sum of the blob contents.
     */
    public val contentMd5: Output<String>?
        get() = javaResource.contentMd5().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The content type of the storage blob.
     */
    public val contentType: Output<String>?
        get() = javaResource.contentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of custom blob metadata.
     */
    public val metadata: Output<Map<String, String>>
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The name of the storage blob.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the storage blob to be created.
     */
    public val type: Output<BlobType>
        get() = javaResource.type().applyValue({ args0 -> args0.let({ args0 -> blobTypeToKotlin(args0) }) })

    /**
     * The URL of the blob.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })
}

public object BlobMapper : ResourceMapper<Blob> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.Blob::class == javaResource::class

    override fun map(javaResource: Resource): Blob = Blob(
        javaResource as
            com.pulumi.azurenative.storage.Blob,
    )
}

/**
 * @see [Blob].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Blob].
 */
public suspend fun blob(name: String, block: suspend BlobResourceBuilder.() -> Unit): Blob {
    val builder = BlobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Blob].
 * @param name The _unique_ name of the resulting resource.
 */
public fun blob(name: String): Blob {
    val builder = BlobResourceBuilder()
    builder.name(name)
    return builder.build()
}
