@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.kotlin.outputs.ImmutabilityPolicyPropertiesResponse
import com.pulumi.azurenative.storage.kotlin.outputs.ImmutableStorageWithVersioningResponse
import com.pulumi.azurenative.storage.kotlin.outputs.LegalHoldPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.storage.kotlin.outputs.ImmutabilityPolicyPropertiesResponse.Companion.toKotlin as immutabilityPolicyPropertiesResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.ImmutableStorageWithVersioningResponse.Companion.toKotlin as immutableStorageWithVersioningResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.LegalHoldPropertiesResponse.Companion.toKotlin as legalHoldPropertiesResponseToKotlin

/**
 * Builder for [BlobContainer].
 */
@PulumiTagMarker
public class BlobContainerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BlobContainerArgs = BlobContainerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BlobContainerArgsBuilder.() -> Unit) {
        val builder = BlobContainerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BlobContainer {
        val builtJavaResource = com.pulumi.azurenative.storage.BlobContainer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BlobContainer(builtJavaResource)
    }
}

/**
 * Properties of the blob container, including Id, resource name, resource type, Etag.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01, 2023-04-01.
 * ## Example Usage
 * ### PutContainerWithDefaultEncryptionScope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainer = new AzureNative.Storage.BlobContainer("blobContainer", new()
 *     {
 *         AccountName = "sto328",
 *         ContainerName = "container6185",
 *         DefaultEncryptionScope = "encryptionscope185",
 *         DenyEncryptionScopeOverride = true,
 *         ResourceGroupName = "res3376",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobContainer(ctx, "blobContainer", &storage.BlobContainerArgs{
 * 			AccountName:                 pulumi.String("sto328"),
 * 			ContainerName:               pulumi.String("container6185"),
 * 			DefaultEncryptionScope:      pulumi.String("encryptionscope185"),
 * 			DenyEncryptionScopeOverride: pulumi.Bool(true),
 * 			ResourceGroupName:           pulumi.String("res3376"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobContainer;
 * import com.pulumi.azurenative.storage.BlobContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainer = new BlobContainer("blobContainer", BlobContainerArgs.builder()
 *             .accountName("sto328")
 *             .containerName("container6185")
 *             .defaultEncryptionScope("encryptionscope185")
 *             .denyEncryptionScopeOverride(true)
 *             .resourceGroupName("res3376")
 *             .build());
 *     }
 * }
 * ```
 * ### PutContainerWithObjectLevelWorm
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainer = new AzureNative.Storage.BlobContainer("blobContainer", new()
 *     {
 *         AccountName = "sto328",
 *         ContainerName = "container6185",
 *         ImmutableStorageWithVersioning = new AzureNative.Storage.Inputs.ImmutableStorageWithVersioningArgs
 *         {
 *             Enabled = true,
 *         },
 *         ResourceGroupName = "res3376",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobContainer(ctx, "blobContainer", &storage.BlobContainerArgs{
 * 			AccountName:   pulumi.String("sto328"),
 * 			ContainerName: pulumi.String("container6185"),
 * 			ImmutableStorageWithVersioning: &storage.ImmutableStorageWithVersioningArgs{
 * 				Enabled: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName: pulumi.String("res3376"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobContainer;
 * import com.pulumi.azurenative.storage.BlobContainerArgs;
 * import com.pulumi.azurenative.storage.inputs.ImmutableStorageWithVersioningArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainer = new BlobContainer("blobContainer", BlobContainerArgs.builder()
 *             .accountName("sto328")
 *             .containerName("container6185")
 *             .immutableStorageWithVersioning(ImmutableStorageWithVersioningArgs.builder()
 *                 .enabled(true)
 *                 .build())
 *             .resourceGroupName("res3376")
 *             .build());
 *     }
 * }
 * ```
 * ### PutContainers
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainer = new AzureNative.Storage.BlobContainer("blobContainer", new()
 *     {
 *         AccountName = "sto328",
 *         ContainerName = "container6185",
 *         ResourceGroupName = "res3376",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewBlobContainer(ctx, "blobContainer", &storage.BlobContainerArgs{
 * 			AccountName:       pulumi.String("sto328"),
 * 			ContainerName:     pulumi.String("container6185"),
 * 			ResourceGroupName: pulumi.String("res3376"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobContainer;
 * import com.pulumi.azurenative.storage.BlobContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainer = new BlobContainer("blobContainer", BlobContainerArgs.builder()
 *             .accountName("sto328")
 *             .containerName("container6185")
 *             .resourceGroupName("res3376")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:BlobContainer container6185 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}
 * ```
 */
public class BlobContainer internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.BlobContainer,
) : KotlinCustomResource(javaResource, BlobContainerMapper) {
    /**
     * Default the container to use specified encryption scope for all writes.
     */
    public val defaultEncryptionScope: Output<String>?
        get() = javaResource.defaultEncryptionScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the blob container was deleted.
     */
    public val deleted: Output<Boolean>
        get() = javaResource.deleted().applyValue({ args0 -> args0 })

    /**
     * Blob container deletion time.
     */
    public val deletedTime: Output<String>
        get() = javaResource.deletedTime().applyValue({ args0 -> args0 })

    /**
     * Block override of encryption scope from the container default.
     */
    public val denyEncryptionScopeOverride: Output<Boolean>?
        get() = javaResource.denyEncryptionScopeOverride().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable NFSv3 all squash on blob container.
     */
    public val enableNfsV3AllSquash: Output<Boolean>?
        get() = javaResource.enableNfsV3AllSquash().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable NFSv3 root squash on blob container.
     */
    public val enableNfsV3RootSquash: Output<Boolean>?
        get() = javaResource.enableNfsV3RootSquash().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The hasImmutabilityPolicy public property is set to true by SRP if ImmutabilityPolicy has been created for this container. The hasImmutabilityPolicy public property is set to false by SRP if ImmutabilityPolicy has not been created for this container.
     */
    public val hasImmutabilityPolicy: Output<Boolean>
        get() = javaResource.hasImmutabilityPolicy().applyValue({ args0 -> args0 })

    /**
     * The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold public property is set to false by SRP if all existing legal hold tags are cleared out. There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
     */
    public val hasLegalHold: Output<Boolean>
        get() = javaResource.hasLegalHold().applyValue({ args0 -> args0 })

    /**
     * The ImmutabilityPolicy property of the container.
     */
    public val immutabilityPolicy: Output<ImmutabilityPolicyPropertiesResponse>
        get() = javaResource.immutabilityPolicy().applyValue({ args0 ->
            args0.let({ args0 ->
                immutabilityPolicyPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The object level immutability property of the container. The property is immutable and can only be set to true at the container creation time. Existing containers must undergo a migration process.
     */
    public val immutableStorageWithVersioning: Output<ImmutableStorageWithVersioningResponse>?
        get() = javaResource.immutableStorageWithVersioning().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> immutableStorageWithVersioningResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Returns the date and time the container was last modified.
     */
    public val lastModifiedTime: Output<String>
        get() = javaResource.lastModifiedTime().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the lease on a container is of infinite or fixed duration, only when the container is leased.
     */
    public val leaseDuration: Output<String>
        get() = javaResource.leaseDuration().applyValue({ args0 -> args0 })

    /**
     * Lease state of the container.
     */
    public val leaseState: Output<String>
        get() = javaResource.leaseState().applyValue({ args0 -> args0 })

    /**
     * The lease status of the container.
     */
    public val leaseStatus: Output<String>
        get() = javaResource.leaseStatus().applyValue({ args0 -> args0 })

    /**
     * The LegalHold property of the container.
     */
    public val legalHold: Output<LegalHoldPropertiesResponse>
        get() = javaResource.legalHold().applyValue({ args0 ->
            args0.let({ args0 ->
                legalHoldPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * A name-value pair to associate with the container as metadata.
     */
    public val metadata: Output<Map<String, String>>?
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies whether data in the container may be accessed publicly and the level of access.
     */
    public val publicAccess: Output<String>?
        get() = javaResource.publicAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Remaining retention days for soft deleted blob container.
     */
    public val remainingRetentionDays: Output<Int>
        get() = javaResource.remainingRetentionDays().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The version of the deleted blob container.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object BlobContainerMapper : ResourceMapper<BlobContainer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.BlobContainer::class == javaResource::class

    override fun map(javaResource: Resource): BlobContainer = BlobContainer(
        javaResource as
            com.pulumi.azurenative.storage.BlobContainer,
    )
}

/**
 * @see [BlobContainer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BlobContainer].
 */
public suspend fun blobContainer(
    name: String,
    block: suspend BlobContainerResourceBuilder.() -> Unit,
): BlobContainer {
    val builder = BlobContainerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BlobContainer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun blobContainer(name: String): BlobContainer {
    val builder = BlobContainerResourceBuilder()
    builder.name(name)
    return builder.build()
}
