@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.EncryptionScopeArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.EncryptionScopeSource
import com.pulumi.azurenative.storage.kotlin.enums.EncryptionScopeState
import com.pulumi.azurenative.storage.kotlin.inputs.EncryptionScopeKeyVaultPropertiesArgs
import com.pulumi.azurenative.storage.kotlin.inputs.EncryptionScopeKeyVaultPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Encryption Scope resource.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01, 2023-04-01.
 * ## Example Usage
 * ### StorageAccountPutEncryptionScope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var encryptionScope = new AzureNative.Storage.EncryptionScope("encryptionScope", new()
 *     {
 *         AccountName = "{storage-account-name}",
 *         EncryptionScopeName = "{encryption-scope-name}",
 *         ResourceGroupName = "resource-group-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewEncryptionScope(ctx, "encryptionScope", &storage.EncryptionScopeArgs{
 * 			AccountName:         pulumi.String("{storage-account-name}"),
 * 			EncryptionScopeName: pulumi.String("{encryption-scope-name}"),
 * 			ResourceGroupName:   pulumi.String("resource-group-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.EncryptionScope;
 * import com.pulumi.azurenative.storage.EncryptionScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var encryptionScope = new EncryptionScope("encryptionScope", EncryptionScopeArgs.builder()
 *             .accountName("{storage-account-name}")
 *             .encryptionScopeName("{encryption-scope-name}")
 *             .resourceGroupName("resource-group-name")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountPutEncryptionScopeWithInfrastructureEncryption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var encryptionScope = new AzureNative.Storage.EncryptionScope("encryptionScope", new()
 *     {
 *         AccountName = "{storage-account-name}",
 *         EncryptionScopeName = "{encryption-scope-name}",
 *         RequireInfrastructureEncryption = true,
 *         ResourceGroupName = "resource-group-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewEncryptionScope(ctx, "encryptionScope", &storage.EncryptionScopeArgs{
 * 			AccountName:                     pulumi.String("{storage-account-name}"),
 * 			EncryptionScopeName:             pulumi.String("{encryption-scope-name}"),
 * 			RequireInfrastructureEncryption: pulumi.Bool(true),
 * 			ResourceGroupName:               pulumi.String("resource-group-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.EncryptionScope;
 * import com.pulumi.azurenative.storage.EncryptionScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var encryptionScope = new EncryptionScope("encryptionScope", EncryptionScopeArgs.builder()
 *             .accountName("{storage-account-name}")
 *             .encryptionScopeName("{encryption-scope-name}")
 *             .requireInfrastructureEncryption(true)
 *             .resourceGroupName("resource-group-name")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:EncryptionScope {encryption-scope-name} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/encryptionScopes/{encryptionScopeName}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property encryptionScopeName The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
 * @property keyVaultProperties The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
 * @property requireInfrastructureEncryption A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property source The provider for the encryption scope. Possible values (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault.
 * @property state The state of the encryption scope. Possible values (case-insensitive):  Enabled, Disabled.
 */
public data class EncryptionScopeArgs(
    public val accountName: Output<String>? = null,
    public val encryptionScopeName: Output<String>? = null,
    public val keyVaultProperties: Output<EncryptionScopeKeyVaultPropertiesArgs>? = null,
    public val requireInfrastructureEncryption: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<Either<String, EncryptionScopeSource>>? = null,
    public val state: Output<Either<String, EncryptionScopeState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.EncryptionScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.EncryptionScopeArgs =
        com.pulumi.azurenative.storage.EncryptionScopeArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .encryptionScopeName(encryptionScopeName?.applyValue({ args0 -> args0 }))
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .requireInfrastructureEncryption(requireInfrastructureEncryption?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(
                source?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionScopeArgs].
 */
@PulumiTagMarker
public class EncryptionScopeArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var encryptionScopeName: Output<String>? = null

    private var keyVaultProperties: Output<EncryptionScopeKeyVaultPropertiesArgs>? = null

    private var requireInfrastructureEncryption: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<Either<String, EncryptionScopeSource>>? = null

    private var state: Output<Either<String, EncryptionScopeState>>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("btyceisbdmjefpju")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     */
    @JvmName("ucgnkgdeicphvhld")
    public suspend fun encryptionScopeName(`value`: Output<String>) {
        this.encryptionScopeName = value
    }

    /**
     * @param value The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
     */
    @JvmName("srlswwgtawcicbks")
    public suspend fun keyVaultProperties(`value`: Output<EncryptionScopeKeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
     */
    @JvmName("rrublnrbgdlxbphi")
    public suspend fun requireInfrastructureEncryption(`value`: Output<Boolean>) {
        this.requireInfrastructureEncryption = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("xetohxvmqvcuxarg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The provider for the encryption scope. Possible values (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault.
     */
    @JvmName("pmhjrcfvenqyifhd")
    public suspend fun source(`value`: Output<Either<String, EncryptionScopeSource>>) {
        this.source = value
    }

    /**
     * @param value The state of the encryption scope. Possible values (case-insensitive):  Enabled, Disabled.
     */
    @JvmName("iltjvwckoxiyomxh")
    public suspend fun state(`value`: Output<Either<String, EncryptionScopeState>>) {
        this.state = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("xtwxpvjefhoetbrs")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the encryption scope within the specified storage account. Encryption scope names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     */
    @JvmName("ehvxjkxjvecohyvu")
    public suspend fun encryptionScopeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionScopeName = mapped
    }

    /**
     * @param value The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
     */
    @JvmName("qjfesepdgggnplso")
    public suspend fun keyVaultProperties(`value`: EncryptionScopeKeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
     */
    @JvmName("xtbdcfwsdplteqit")
    public suspend
    fun keyVaultProperties(argument: suspend EncryptionScopeKeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionScopeKeyVaultPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param value A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
     */
    @JvmName("iogacperniregwhx")
    public suspend fun requireInfrastructureEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireInfrastructureEncryption = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("qieksxbaclgrhlef")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The provider for the encryption scope. Possible values (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault.
     */
    @JvmName("edbnusyfevvypqhe")
    public suspend fun source(`value`: Either<String, EncryptionScopeSource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The provider for the encryption scope. Possible values (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault.
     */
    @JvmName("blixtgvacjfxhjqa")
    public fun source(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionScopeSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The provider for the encryption scope. Possible values (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault.
     */
    @JvmName("mpfxbxfrlkrnymnu")
    public fun source(`value`: EncryptionScopeSource) {
        val toBeMapped = Either.ofRight<String, EncryptionScopeSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The state of the encryption scope. Possible values (case-insensitive):  Enabled, Disabled.
     */
    @JvmName("jbsjieewgqhkjilf")
    public suspend fun state(`value`: Either<String, EncryptionScopeState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state of the encryption scope. Possible values (case-insensitive):  Enabled, Disabled.
     */
    @JvmName("tkuffdspvnipwckf")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionScopeState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state of the encryption scope. Possible values (case-insensitive):  Enabled, Disabled.
     */
    @JvmName("hrjngghxnpujtbfy")
    public fun state(`value`: EncryptionScopeState) {
        val toBeMapped = Either.ofRight<String, EncryptionScopeState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): EncryptionScopeArgs = EncryptionScopeArgs(
        accountName = accountName,
        encryptionScopeName = encryptionScopeName,
        keyVaultProperties = keyVaultProperties,
        requireInfrastructureEncryption = requireInfrastructureEncryption,
        resourceGroupName = resourceGroupName,
        source = source,
        state = state,
    )
}
