@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.kotlin.outputs.CorsRulesResponse
import com.pulumi.azurenative.storage.kotlin.outputs.DeleteRetentionPolicyResponse
import com.pulumi.azurenative.storage.kotlin.outputs.ProtocolSettingsResponse
import com.pulumi.azurenative.storage.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.storage.kotlin.outputs.CorsRulesResponse.Companion.toKotlin as corsRulesResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.DeleteRetentionPolicyResponse.Companion.toKotlin as deleteRetentionPolicyResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.ProtocolSettingsResponse.Companion.toKotlin as protocolSettingsResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [FileServiceProperties].
 */
@PulumiTagMarker
public class FileServicePropertiesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FileServicePropertiesArgs = FileServicePropertiesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FileServicePropertiesArgsBuilder.() -> Unit) {
        val builder = FileServicePropertiesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FileServiceProperties {
        val builtJavaResource =
            com.pulumi.azurenative.storage.FileServiceProperties(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FileServiceProperties(builtJavaResource)
    }
}

/**
 * The properties of File services in storage account.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01, 2023-04-01.
 * ## Example Usage
 * ### PutFileServices
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileServiceProperties = new AzureNative.Storage.FileServiceProperties("fileServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         Cors = new AzureNative.Storage.Inputs.CorsRulesArgs
 *         {
 *             CorsRules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         AzureNative.Storage.AllowedMethods.GET,
 *                         AzureNative.Storage.AllowedMethods.HEAD,
 *                         AzureNative.Storage.AllowedMethods.POST,
 *                         AzureNative.Storage.AllowedMethods.OPTIONS,
 *                         AzureNative.Storage.AllowedMethods.MERGE,
 *                         AzureNative.Storage.AllowedMethods.PUT,
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.contoso.com",
 *                         "http://www.fabrikam.com",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-*",
 *                     },
 *                     MaxAgeInSeconds = 100,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         AzureNative.Storage.AllowedMethods.GET,
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     MaxAgeInSeconds = 2,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-12345675754564*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         AzureNative.Storage.AllowedMethods.GET,
 *                         AzureNative.Storage.AllowedMethods.PUT,
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.abc23.com",
 *                         "https://www.fabrikam.com/*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*",
 *                     },
 *                     MaxAgeInSeconds = 2000,
 *                 },
 *             },
 *         },
 *         FileServicesName = "default",
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewFileServiceProperties(ctx, "fileServiceProperties", &storage.FileServicePropertiesArgs{
 * 			AccountName: pulumi.String("sto8607"),
 * 			Cors: &storage.CorsRulesArgs{
 * 				CorsRules: storage.CorsRuleArray{
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x-ms-meta-target*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String(storage.AllowedMethodsGET),
 * 							pulumi.String(storage.AllowedMethodsHEAD),
 * 							pulumi.String(storage.AllowedMethodsPOST),
 * 							pulumi.String(storage.AllowedMethodsOPTIONS),
 * 							pulumi.String(storage.AllowedMethodsMERGE),
 * 							pulumi.String(storage.AllowedMethodsPUT),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.contoso.com"),
 * 							pulumi.String("http://www.fabrikam.com"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(100),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String(storage.AllowedMethodsGET),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-12345675754564*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String(storage.AllowedMethodsGET),
 * 							pulumi.String(storage.AllowedMethodsPUT),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.abc23.com"),
 * 							pulumi.String("https://www.fabrikam.com/*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x-ms-meta-target*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2000),
 * 					},
 * 				},
 * 			},
 * 			FileServicesName:  pulumi.String("default"),
 * 			ResourceGroupName: pulumi.String("res4410"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.FileServiceProperties;
 * import com.pulumi.azurenative.storage.FileServicePropertiesArgs;
 * import com.pulumi.azurenative.storage.inputs.CorsRulesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileServiceProperties = new FileServiceProperties("fileServiceProperties", FileServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .cors(CorsRulesArgs.builder()
 *                 .corsRules(
 *                     CorsRuleArgs.builder()
 *                         .allowedHeaders(
 *                             "x-ms-meta-abc",
 *                             "x-ms-meta-data*",
 *                             "x-ms-meta-target*")
 *                         .allowedMethods(
 *                             "GET",
 *                             "HEAD",
 *                             "POST",
 *                             "OPTIONS",
 *                             "MERGE",
 *                             "PUT")
 *                         .allowedOrigins(
 *                             "http://www.contoso.com",
 *                             "http://www.fabrikam.com")
 *                         .exposedHeaders("x-ms-meta-*")
 *                         .maxAgeInSeconds(100)
 *                         .build(),
 *                     CorsRuleArgs.builder()
 *                         .allowedHeaders("*")
 *                         .allowedMethods("GET")
 *                         .allowedOrigins("*")
 *                         .exposedHeaders("*")
 *                         .maxAgeInSeconds(2)
 *                         .build(),
 *                     CorsRuleArgs.builder()
 *                         .allowedHeaders("x-ms-meta-12345675754564*")
 *                         .allowedMethods(
 *                             "GET",
 *                             "PUT")
 *                         .allowedOrigins(
 *                             "http://www.abc23.com",
 *                             "https://www.fabrikam.com/*")
 *                         .exposedHeaders(
 *                             "x-ms-meta-abc",
 *                             "x-ms-meta-data*",
 *                             "x-ms-meta-target*")
 *                         .maxAgeInSeconds(2000)
 *                         .build())
 *                 .build())
 *             .fileServicesName("default")
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ### PutFileServices_EnableSMBMultichannel
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileServiceProperties = new AzureNative.Storage.FileServiceProperties("fileServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         FileServicesName = "default",
 *         ProtocolSettings = new AzureNative.Storage.Inputs.ProtocolSettingsArgs
 *         {
 *             Smb = new AzureNative.Storage.Inputs.SmbSettingArgs
 *             {
 *                 Multichannel = new AzureNative.Storage.Inputs.MultichannelArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewFileServiceProperties(ctx, "fileServiceProperties", &storage.FileServicePropertiesArgs{
 * 			AccountName:      pulumi.String("sto8607"),
 * 			FileServicesName: pulumi.String("default"),
 * 			ProtocolSettings: &storage.ProtocolSettingsArgs{
 * 				Smb: &storage.SmbSettingArgs{
 * 					Multichannel: &storage.MultichannelArgs{
 * 						Enabled: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res4410"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.FileServiceProperties;
 * import com.pulumi.azurenative.storage.FileServicePropertiesArgs;
 * import com.pulumi.azurenative.storage.inputs.ProtocolSettingsArgs;
 * import com.pulumi.azurenative.storage.inputs.SmbSettingArgs;
 * import com.pulumi.azurenative.storage.inputs.MultichannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileServiceProperties = new FileServiceProperties("fileServiceProperties", FileServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .fileServicesName("default")
 *             .protocolSettings(ProtocolSettingsArgs.builder()
 *                 .smb(SmbSettingArgs.builder()
 *                     .multichannel(MultichannelArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ### PutFileServices_EnableSecureSmbFeatures
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileServiceProperties = new AzureNative.Storage.FileServiceProperties("fileServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         FileServicesName = "default",
 *         ProtocolSettings = new AzureNative.Storage.Inputs.ProtocolSettingsArgs
 *         {
 *             Smb = new AzureNative.Storage.Inputs.SmbSettingArgs
 *             {
 *                 AuthenticationMethods = "NTLMv2;Kerberos",
 *                 ChannelEncryption = "AES-128-CCM;AES-128-GCM;AES-256-GCM",
 *                 KerberosTicketEncryption = "RC4-HMAC;AES-256",
 *                 Versions = "SMB2.1;SMB3.0;SMB3.1.1",
 *             },
 *         },
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewFileServiceProperties(ctx, "fileServiceProperties", &storage.FileServicePropertiesArgs{
 * 			AccountName:      pulumi.String("sto8607"),
 * 			FileServicesName: pulumi.String("default"),
 * 			ProtocolSettings: &storage.ProtocolSettingsArgs{
 * 				Smb: &storage.SmbSettingArgs{
 * 					AuthenticationMethods:    pulumi.String("NTLMv2;Kerberos"),
 * 					ChannelEncryption:        pulumi.String("AES-128-CCM;AES-128-GCM;AES-256-GCM"),
 * 					KerberosTicketEncryption: pulumi.String("RC4-HMAC;AES-256"),
 * 					Versions:                 pulumi.String("SMB2.1;SMB3.0;SMB3.1.1"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res4410"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.FileServiceProperties;
 * import com.pulumi.azurenative.storage.FileServicePropertiesArgs;
 * import com.pulumi.azurenative.storage.inputs.ProtocolSettingsArgs;
 * import com.pulumi.azurenative.storage.inputs.SmbSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileServiceProperties = new FileServiceProperties("fileServiceProperties", FileServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .fileServicesName("default")
 *             .protocolSettings(ProtocolSettingsArgs.builder()
 *                 .smb(SmbSettingArgs.builder()
 *                     .authenticationMethods("NTLMv2;Kerberos")
 *                     .channelEncryption("AES-128-CCM;AES-128-GCM;AES-256-GCM")
 *                     .kerberosTicketEncryption("RC4-HMAC;AES-256")
 *                     .versions("SMB2.1;SMB3.0;SMB3.1.1")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:FileServiceProperties default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/{FileServicesName}
 * ```
 * */*/*/
 */
public class FileServiceProperties internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.FileServiceProperties,
) : KotlinCustomResource(javaResource, FileServicePropertiesMapper) {
    /**
     * Specifies CORS rules for the File service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the File service.
     */
    public val cors: Output<CorsRulesResponse>?
        get() = javaResource.cors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    corsRulesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Protocol settings for file service
     */
    public val protocolSettings: Output<ProtocolSettingsResponse>?
        get() = javaResource.protocolSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> protocolSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The file service properties for share soft delete.
     */
    public val shareDeleteRetentionPolicy: Output<DeleteRetentionPolicyResponse>?
        get() = javaResource.shareDeleteRetentionPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deleteRetentionPolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Sku name and tier.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FileServicePropertiesMapper : ResourceMapper<FileServiceProperties> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.FileServiceProperties::class == javaResource::class

    override fun map(javaResource: Resource): FileServiceProperties =
        FileServiceProperties(javaResource as com.pulumi.azurenative.storage.FileServiceProperties)
}

/**
 * @see [FileServiceProperties].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FileServiceProperties].
 */
public suspend fun fileServiceProperties(
    name: String,
    block: suspend FileServicePropertiesResourceBuilder.() -> Unit,
): FileServiceProperties {
    val builder = FileServicePropertiesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FileServiceProperties].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fileServiceProperties(name: String): FileServiceProperties {
    val builder = FileServicePropertiesResourceBuilder()
    builder.name(name)
    return builder.build()
}
