@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.FileServicePropertiesArgs.builder
import com.pulumi.azurenative.storage.kotlin.inputs.CorsRulesArgs
import com.pulumi.azurenative.storage.kotlin.inputs.CorsRulesArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.DeleteRetentionPolicyArgs
import com.pulumi.azurenative.storage.kotlin.inputs.DeleteRetentionPolicyArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.ProtocolSettingsArgs
import com.pulumi.azurenative.storage.kotlin.inputs.ProtocolSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of File services in storage account.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01, 2023-04-01.
 * ## Example Usage
 * ### PutFileServices
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileServiceProperties = new AzureNative.Storage.FileServiceProperties("fileServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         Cors = new AzureNative.Storage.Inputs.CorsRulesArgs
 *         {
 *             CorsRules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         AzureNative.Storage.AllowedMethods.GET,
 *                         AzureNative.Storage.AllowedMethods.HEAD,
 *                         AzureNative.Storage.AllowedMethods.POST,
 *                         AzureNative.Storage.AllowedMethods.OPTIONS,
 *                         AzureNative.Storage.AllowedMethods.MERGE,
 *                         AzureNative.Storage.AllowedMethods.PUT,
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.contoso.com",
 *                         "http://www.fabrikam.com",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-*",
 *                     },
 *                     MaxAgeInSeconds = 100,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         AzureNative.Storage.AllowedMethods.GET,
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "*",
 *                     },
 *                     MaxAgeInSeconds = 2,
 *                 },
 *                 new AzureNative.Storage.Inputs.CorsRuleArgs
 *                 {
 *                     AllowedHeaders = new[]
 *                     {
 *                         "x-ms-meta-12345675754564*",
 *                     },
 *                     AllowedMethods = new[]
 *                     {
 *                         AzureNative.Storage.AllowedMethods.GET,
 *                         AzureNative.Storage.AllowedMethods.PUT,
 *                     },
 *                     AllowedOrigins = new[]
 *                     {
 *                         "http://www.abc23.com",
 *                         "https://www.fabrikam.com/*",
 *                     },
 *                     ExposedHeaders = new[]
 *                     {
 *                         "x-ms-meta-abc",
 *                         "x-ms-meta-data*",
 *                         "x-ms-meta-target*",
 *                     },
 *                     MaxAgeInSeconds = 2000,
 *                 },
 *             },
 *         },
 *         FileServicesName = "default",
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewFileServiceProperties(ctx, "fileServiceProperties", &storage.FileServicePropertiesArgs{
 * 			AccountName: pulumi.String("sto8607"),
 * 			Cors: &storage.CorsRulesArgs{
 * 				CorsRules: storage.CorsRuleArray{
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x-ms-meta-target*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String(storage.AllowedMethodsGET),
 * 							pulumi.String(storage.AllowedMethodsHEAD),
 * 							pulumi.String(storage.AllowedMethodsPOST),
 * 							pulumi.String(storage.AllowedMethodsOPTIONS),
 * 							pulumi.String(storage.AllowedMethodsMERGE),
 * 							pulumi.String(storage.AllowedMethodsPUT),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.contoso.com"),
 * 							pulumi.String("http://www.fabrikam.com"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(100),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String(storage.AllowedMethodsGET),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2),
 * 					},
 * 					&storage.CorsRuleArgs{
 * 						AllowedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-12345675754564*"),
 * 						},
 * 						AllowedMethods: pulumi.StringArray{
 * 							pulumi.String(storage.AllowedMethodsGET),
 * 							pulumi.String(storage.AllowedMethodsPUT),
 * 						},
 * 						AllowedOrigins: pulumi.StringArray{
 * 							pulumi.String("http://www.abc23.com"),
 * 							pulumi.String("https://www.fabrikam.com/*"),
 * 						},
 * 						ExposedHeaders: pulumi.StringArray{
 * 							pulumi.String("x-ms-meta-abc"),
 * 							pulumi.String("x-ms-meta-data*"),
 * 							pulumi.String("x-ms-meta-target*"),
 * 						},
 * 						MaxAgeInSeconds: pulumi.Int(2000),
 * 					},
 * 				},
 * 			},
 * 			FileServicesName:  pulumi.String("default"),
 * 			ResourceGroupName: pulumi.String("res4410"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.FileServiceProperties;
 * import com.pulumi.azurenative.storage.FileServicePropertiesArgs;
 * import com.pulumi.azurenative.storage.inputs.CorsRulesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileServiceProperties = new FileServiceProperties("fileServiceProperties", FileServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .cors(CorsRulesArgs.builder()
 *                 .corsRules(
 *                     CorsRuleArgs.builder()
 *                         .allowedHeaders(
 *                             "x-ms-meta-abc",
 *                             "x-ms-meta-data*",
 *                             "x-ms-meta-target*")
 *                         .allowedMethods(
 *                             "GET",
 *                             "HEAD",
 *                             "POST",
 *                             "OPTIONS",
 *                             "MERGE",
 *                             "PUT")
 *                         .allowedOrigins(
 *                             "http://www.contoso.com",
 *                             "http://www.fabrikam.com")
 *                         .exposedHeaders("x-ms-meta-*")
 *                         .maxAgeInSeconds(100)
 *                         .build(),
 *                     CorsRuleArgs.builder()
 *                         .allowedHeaders("*")
 *                         .allowedMethods("GET")
 *                         .allowedOrigins("*")
 *                         .exposedHeaders("*")
 *                         .maxAgeInSeconds(2)
 *                         .build(),
 *                     CorsRuleArgs.builder()
 *                         .allowedHeaders("x-ms-meta-12345675754564*")
 *                         .allowedMethods(
 *                             "GET",
 *                             "PUT")
 *                         .allowedOrigins(
 *                             "http://www.abc23.com",
 *                             "https://www.fabrikam.com/*")
 *                         .exposedHeaders(
 *                             "x-ms-meta-abc",
 *                             "x-ms-meta-data*",
 *                             "x-ms-meta-target*")
 *                         .maxAgeInSeconds(2000)
 *                         .build())
 *                 .build())
 *             .fileServicesName("default")
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ### PutFileServices_EnableSMBMultichannel
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileServiceProperties = new AzureNative.Storage.FileServiceProperties("fileServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         FileServicesName = "default",
 *         ProtocolSettings = new AzureNative.Storage.Inputs.ProtocolSettingsArgs
 *         {
 *             Smb = new AzureNative.Storage.Inputs.SmbSettingArgs
 *             {
 *                 Multichannel = new AzureNative.Storage.Inputs.MultichannelArgs
 *                 {
 *                     Enabled = true,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewFileServiceProperties(ctx, "fileServiceProperties", &storage.FileServicePropertiesArgs{
 * 			AccountName:      pulumi.String("sto8607"),
 * 			FileServicesName: pulumi.String("default"),
 * 			ProtocolSettings: &storage.ProtocolSettingsArgs{
 * 				Smb: &storage.SmbSettingArgs{
 * 					Multichannel: &storage.MultichannelArgs{
 * 						Enabled: pulumi.Bool(true),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res4410"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.FileServiceProperties;
 * import com.pulumi.azurenative.storage.FileServicePropertiesArgs;
 * import com.pulumi.azurenative.storage.inputs.ProtocolSettingsArgs;
 * import com.pulumi.azurenative.storage.inputs.SmbSettingArgs;
 * import com.pulumi.azurenative.storage.inputs.MultichannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileServiceProperties = new FileServiceProperties("fileServiceProperties", FileServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .fileServicesName("default")
 *             .protocolSettings(ProtocolSettingsArgs.builder()
 *                 .smb(SmbSettingArgs.builder()
 *                     .multichannel(MultichannelArgs.builder()
 *                         .enabled(true)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ### PutFileServices_EnableSecureSmbFeatures
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileServiceProperties = new AzureNative.Storage.FileServiceProperties("fileServiceProperties", new()
 *     {
 *         AccountName = "sto8607",
 *         FileServicesName = "default",
 *         ProtocolSettings = new AzureNative.Storage.Inputs.ProtocolSettingsArgs
 *         {
 *             Smb = new AzureNative.Storage.Inputs.SmbSettingArgs
 *             {
 *                 AuthenticationMethods = "NTLMv2;Kerberos",
 *                 ChannelEncryption = "AES-128-CCM;AES-128-GCM;AES-256-GCM",
 *                 KerberosTicketEncryption = "RC4-HMAC;AES-256",
 *                 Versions = "SMB2.1;SMB3.0;SMB3.1.1",
 *             },
 *         },
 *         ResourceGroupName = "res4410",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewFileServiceProperties(ctx, "fileServiceProperties", &storage.FileServicePropertiesArgs{
 * 			AccountName:      pulumi.String("sto8607"),
 * 			FileServicesName: pulumi.String("default"),
 * 			ProtocolSettings: &storage.ProtocolSettingsArgs{
 * 				Smb: &storage.SmbSettingArgs{
 * 					AuthenticationMethods:    pulumi.String("NTLMv2;Kerberos"),
 * 					ChannelEncryption:        pulumi.String("AES-128-CCM;AES-128-GCM;AES-256-GCM"),
 * 					KerberosTicketEncryption: pulumi.String("RC4-HMAC;AES-256"),
 * 					Versions:                 pulumi.String("SMB2.1;SMB3.0;SMB3.1.1"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res4410"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.FileServiceProperties;
 * import com.pulumi.azurenative.storage.FileServicePropertiesArgs;
 * import com.pulumi.azurenative.storage.inputs.ProtocolSettingsArgs;
 * import com.pulumi.azurenative.storage.inputs.SmbSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileServiceProperties = new FileServiceProperties("fileServiceProperties", FileServicePropertiesArgs.builder()
 *             .accountName("sto8607")
 *             .fileServicesName("default")
 *             .protocolSettings(ProtocolSettingsArgs.builder()
 *                 .smb(SmbSettingArgs.builder()
 *                     .authenticationMethods("NTLMv2;Kerberos")
 *                     .channelEncryption("AES-128-CCM;AES-128-GCM;AES-256-GCM")
 *                     .kerberosTicketEncryption("RC4-HMAC;AES-256")
 *                     .versions("SMB2.1;SMB3.0;SMB3.1.1")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("res4410")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:FileServiceProperties default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/{FileServicesName}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property cors Specifies CORS rules for the File service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the File service.
 * @property fileServicesName The name of the file Service within the specified storage account. File Service Name must be "default"
 * @property protocolSettings Protocol settings for file service
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property shareDeleteRetentionPolicy The file service properties for share soft delete.
 * */*/*/
 */
public data class FileServicePropertiesArgs(
    public val accountName: Output<String>? = null,
    public val cors: Output<CorsRulesArgs>? = null,
    public val fileServicesName: Output<String>? = null,
    public val protocolSettings: Output<ProtocolSettingsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareDeleteRetentionPolicy: Output<DeleteRetentionPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.FileServicePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.FileServicePropertiesArgs =
        com.pulumi.azurenative.storage.FileServicePropertiesArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .cors(cors?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fileServicesName(fileServicesName?.applyValue({ args0 -> args0 }))
            .protocolSettings(protocolSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareDeleteRetentionPolicy(
                shareDeleteRetentionPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FileServicePropertiesArgs].
 */
@PulumiTagMarker
public class FileServicePropertiesArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var cors: Output<CorsRulesArgs>? = null

    private var fileServicesName: Output<String>? = null

    private var protocolSettings: Output<ProtocolSettingsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareDeleteRetentionPolicy: Output<DeleteRetentionPolicyArgs>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("xiwxkqbegtsmybdk")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Specifies CORS rules for the File service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the File service.
     */
    @JvmName("hgvggaessbneabmn")
    public suspend fun cors(`value`: Output<CorsRulesArgs>) {
        this.cors = value
    }

    /**
     * @param value The name of the file Service within the specified storage account. File Service Name must be "default"
     */
    @JvmName("bmhopfikgyjjitbf")
    public suspend fun fileServicesName(`value`: Output<String>) {
        this.fileServicesName = value
    }

    /**
     * @param value Protocol settings for file service
     */
    @JvmName("usprtxjvdpddogfp")
    public suspend fun protocolSettings(`value`: Output<ProtocolSettingsArgs>) {
        this.protocolSettings = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("oahiksnidgkwawfg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The file service properties for share soft delete.
     */
    @JvmName("spmoparatbumglpn")
    public suspend fun shareDeleteRetentionPolicy(`value`: Output<DeleteRetentionPolicyArgs>) {
        this.shareDeleteRetentionPolicy = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("vhmepotgnjckqbjp")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Specifies CORS rules for the File service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the File service.
     */
    @JvmName("klmakhkhguuwscod")
    public suspend fun cors(`value`: CorsRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cors = mapped
    }

    /**
     * @param argument Specifies CORS rules for the File service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the File service.
     */
    @JvmName("nuuwrsgluwruhyxk")
    public suspend fun cors(argument: suspend CorsRulesArgsBuilder.() -> Unit) {
        val toBeMapped = CorsRulesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cors = mapped
    }

    /**
     * @param value The name of the file Service within the specified storage account. File Service Name must be "default"
     */
    @JvmName("owbmweuldqjwgjnd")
    public suspend fun fileServicesName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileServicesName = mapped
    }

    /**
     * @param value Protocol settings for file service
     */
    @JvmName("gkvahixaiqducmtm")
    public suspend fun protocolSettings(`value`: ProtocolSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolSettings = mapped
    }

    /**
     * @param argument Protocol settings for file service
     */
    @JvmName("epbthlthnyjmibbx")
    public suspend fun protocolSettings(argument: suspend ProtocolSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ProtocolSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.protocolSettings = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("uhjkutsnmtlsvswv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The file service properties for share soft delete.
     */
    @JvmName("bcivcqcpubopsegx")
    public suspend fun shareDeleteRetentionPolicy(`value`: DeleteRetentionPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareDeleteRetentionPolicy = mapped
    }

    /**
     * @param argument The file service properties for share soft delete.
     */
    @JvmName("fsslxiyoctjammvg")
    public suspend
    fun shareDeleteRetentionPolicy(argument: suspend DeleteRetentionPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = DeleteRetentionPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.shareDeleteRetentionPolicy = mapped
    }

    internal fun build(): FileServicePropertiesArgs = FileServicePropertiesArgs(
        accountName = accountName,
        cors = cors,
        fileServicesName = fileServicesName,
        protocolSettings = protocolSettings,
        resourceGroupName = resourceGroupName,
        shareDeleteRetentionPolicy = shareDeleteRetentionPolicy,
    )
}
