@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.kotlin.outputs.PermissionScopeResponse
import com.pulumi.azurenative.storage.kotlin.outputs.SshPublicKeyResponse
import com.pulumi.azurenative.storage.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.storage.kotlin.outputs.PermissionScopeResponse.Companion.toKotlin as permissionScopeResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.SshPublicKeyResponse.Companion.toKotlin as sshPublicKeyResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [LocalUser].
 */
@PulumiTagMarker
public class LocalUserResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LocalUserArgs = LocalUserArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LocalUserArgsBuilder.() -> Unit) {
        val builder = LocalUserArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LocalUser {
        val builtJavaResource = com.pulumi.azurenative.storage.LocalUser(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LocalUser(builtJavaResource)
    }
}

/**
 * The local user associated with the storage accounts.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-08-01.
 * Other available API versions: 2023-01-01, 2023-04-01.
 * ## Example Usage
 * ### CreateLocalUser
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var localUser = new AzureNative.Storage.LocalUser("localUser", new()
 *     {
 *         AccountName = "sto2527",
 *         HasSshPassword = true,
 *         HomeDirectory = "homedirectory",
 *         PermissionScopes = new[]
 *         {
 *             new AzureNative.Storage.Inputs.PermissionScopeArgs
 *             {
 *                 Permissions = "rwd",
 *                 ResourceName = "share1",
 *                 Service = "file",
 *             },
 *             new AzureNative.Storage.Inputs.PermissionScopeArgs
 *             {
 *                 Permissions = "rw",
 *                 ResourceName = "share2",
 *                 Service = "file",
 *             },
 *         },
 *         ResourceGroupName = "res6977",
 *         SshAuthorizedKeys = new[]
 *         {
 *             new AzureNative.Storage.Inputs.SshPublicKeyArgs
 *             {
 *                 Description = "key name",
 *                 Key = "ssh-rsa keykeykeykeykey=",
 *             },
 *         },
 *         Username = "user1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewLocalUser(ctx, "localUser", &storage.LocalUserArgs{
 * 			AccountName:    pulumi.String("sto2527"),
 * 			HasSshPassword: pulumi.Bool(true),
 * 			HomeDirectory:  pulumi.String("homedirectory"),
 * 			PermissionScopes: storage.PermissionScopeArray{
 * 				&storage.PermissionScopeArgs{
 * 					Permissions:  pulumi.String("rwd"),
 * 					ResourceName: pulumi.String("share1"),
 * 					Service:      pulumi.String("file"),
 * 				},
 * 				&storage.PermissionScopeArgs{
 * 					Permissions:  pulumi.String("rw"),
 * 					ResourceName: pulumi.String("share2"),
 * 					Service:      pulumi.String("file"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res6977"),
 * 			SshAuthorizedKeys: storage.SshPublicKeyArray{
 * 				&storage.SshPublicKeyArgs{
 * 					Description: pulumi.String("key name"),
 * 					Key:         pulumi.String("ssh-rsa keykeykeykeykey="),
 * 				},
 * 			},
 * 			Username: pulumi.String("user1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.LocalUser;
 * import com.pulumi.azurenative.storage.LocalUserArgs;
 * import com.pulumi.azurenative.storage.inputs.PermissionScopeArgs;
 * import com.pulumi.azurenative.storage.inputs.SshPublicKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var localUser = new LocalUser("localUser", LocalUserArgs.builder()
 *             .accountName("sto2527")
 *             .hasSshPassword(true)
 *             .homeDirectory("homedirectory")
 *             .permissionScopes(
 *                 PermissionScopeArgs.builder()
 *                     .permissions("rwd")
 *                     .resourceName("share1")
 *                     .service("file")
 *                     .build(),
 *                 PermissionScopeArgs.builder()
 *                     .permissions("rw")
 *                     .resourceName("share2")
 *                     .service("file")
 *                     .build())
 *             .resourceGroupName("res6977")
 *             .sshAuthorizedKeys(SshPublicKeyArgs.builder()
 *                 .description("key name")
 *                 .key("ssh-rsa keykeykeykeykey=")
 *                 .build())
 *             .username("user1")
 *             .build());
 *     }
 * }
 * ```
 * ### UpdateLocalUser
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var localUser = new AzureNative.Storage.LocalUser("localUser", new()
 *     {
 *         AccountName = "sto2527",
 *         HasSharedKey = false,
 *         HasSshKey = false,
 *         HasSshPassword = false,
 *         HomeDirectory = "homedirectory2",
 *         ResourceGroupName = "res6977",
 *         Username = "user1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewLocalUser(ctx, "localUser", &storage.LocalUserArgs{
 * 			AccountName:       pulumi.String("sto2527"),
 * 			HasSharedKey:      pulumi.Bool(false),
 * 			HasSshKey:         pulumi.Bool(false),
 * 			HasSshPassword:    pulumi.Bool(false),
 * 			HomeDirectory:     pulumi.String("homedirectory2"),
 * 			ResourceGroupName: pulumi.String("res6977"),
 * 			Username:          pulumi.String("user1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.LocalUser;
 * import com.pulumi.azurenative.storage.LocalUserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var localUser = new LocalUser("localUser", LocalUserArgs.builder()
 *             .accountName("sto2527")
 *             .hasSharedKey(false)
 *             .hasSshKey(false)
 *             .hasSshPassword(false)
 *             .homeDirectory("homedirectory2")
 *             .resourceGroupName("res6977")
 *             .username("user1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:LocalUser user1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/localUsers/{username}
 * ```
 */
public class LocalUser internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.LocalUser,
) : KotlinCustomResource(javaResource, LocalUserMapper) {
    /**
     * Indicates whether shared key exists. Set it to false to remove existing shared key.
     */
    public val hasSharedKey: Output<Boolean>?
        get() = javaResource.hasSharedKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether ssh key exists. Set it to false to remove existing SSH key.
     */
    public val hasSshKey: Output<Boolean>?
        get() = javaResource.hasSshKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates whether ssh password exists. Set it to false to remove existing SSH password.
     */
    public val hasSshPassword: Output<Boolean>?
        get() = javaResource.hasSshPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Optional, local user home directory.
     */
    public val homeDirectory: Output<String>?
        get() = javaResource.homeDirectory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The permission scopes of the local user.
     */
    public val permissionScopes: Output<List<PermissionScopeResponse>>?
        get() = javaResource.permissionScopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        permissionScopeResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A unique Security Identifier that is generated by the server.
     */
    public val sid: Output<String>
        get() = javaResource.sid().applyValue({ args0 -> args0 })

    /**
     * Optional, local user ssh authorized keys for SFTP.
     */
    public val sshAuthorizedKeys: Output<List<SshPublicKeyResponse>>?
        get() = javaResource.sshAuthorizedKeys().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        sshPublicKeyResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LocalUserMapper : ResourceMapper<LocalUser> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.LocalUser::class == javaResource::class

    override fun map(javaResource: Resource): LocalUser = LocalUser(
        javaResource as
            com.pulumi.azurenative.storage.LocalUser,
    )
}

/**
 * @see [LocalUser].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LocalUser].
 */
public suspend fun localUser(name: String, block: suspend LocalUserResourceBuilder.() -> Unit):
    LocalUser {
    val builder = LocalUserResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LocalUser].
 * @param name The _unique_ name of the resulting resource.
 */
public fun localUser(name: String): LocalUser {
    val builder = LocalUserResourceBuilder()
    builder.name(name)
    return builder.build()
}
