@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.ManagementPolicyArgs.builder
import com.pulumi.azurenative.storage.kotlin.inputs.ManagementPolicySchemaArgs
import com.pulumi.azurenative.storage.kotlin.inputs.ManagementPolicySchemaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Get Storage Account ManagementPolicies operation response.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2018-03-01-preview, 2023-01-01, 2023-04-01.
 * ## Example Usage
 * ### StorageAccountSetManagementPolicies
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Snapshot = new AzureNative.Storage.Inputs.ManagementPolicySnapShotArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer1",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest1",
 *                     Type = AzureNative.Storage.RuleType.Lifecycle,
 *                 },
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 30,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobIndexMatch = new[]
 *                             {
 *                                 new AzureNative.Storage.Inputs.TagFilterArgs
 *                                 {
 *                                     Name = "tag1",
 *                                     Op = "==",
 *                                     Value = "val1",
 *                                 },
 *                                 new AzureNative.Storage.Inputs.TagFilterArgs
 *                                 {
 *                                     Name = "tag2",
 *                                     Op = "==",
 *                                     Value = "val2",
 *                                 },
 *                             },
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer2",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest2",
 *                     Type = AzureNative.Storage.RuleType.Lifecycle,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * 			AccountName:          pulumi.String("sto9699"),
 * 			ManagementPolicyName: pulumi.String("default"),
 * 			Policy: &storage.ManagementPolicySchemaArgs{
 * 				Rules: storage.ManagementPolicyRuleArray{
 * 					&storage.ManagementPolicyRuleArgs{
 * 						Definition: &storage.ManagementPolicyDefinitionArgs{
 * 							Actions: &storage.ManagementPolicyActionArgs{
 * 								BaseBlob: &storage.ManagementPolicyBaseBlobArgs{
 * 									Delete: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(1000),
 * 									},
 * 									TierToArchive: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(90),
 * 									},
 * 									TierToCool: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 								Snapshot: &storage.ManagementPolicySnapShotArgs{
 * 									Delete: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 							},
 * 							Filters: &storage.ManagementPolicyFilterArgs{
 * 								BlobTypes: pulumi.StringArray{
 * 									pulumi.String("blockBlob"),
 * 								},
 * 								PrefixMatch: pulumi.StringArray{
 * 									pulumi.String("olcmtestcontainer1"),
 * 								},
 * 							},
 * 						},
 * 						Enabled: pulumi.Bool(true),
 * 						Name:    pulumi.String("olcmtest1"),
 * 						Type:    pulumi.String(storage.RuleTypeLifecycle),
 * 					},
 * 					&storage.ManagementPolicyRuleArgs{
 * 						Definition: &storage.ManagementPolicyDefinitionArgs{
 * 							Actions: &storage.ManagementPolicyActionArgs{
 * 								BaseBlob: &storage.ManagementPolicyBaseBlobArgs{
 * 									Delete: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(1000),
 * 									},
 * 									TierToArchive: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(90),
 * 									},
 * 									TierToCool: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 							},
 * 							Filters: &storage.ManagementPolicyFilterArgs{
 * 								BlobIndexMatch: storage.TagFilterArray{
 * 									&storage.TagFilterArgs{
 * 										Name:  pulumi.String("tag1"),
 * 										Op:    pulumi.String("=="),
 * 										Value: pulumi.String("val1"),
 * 									},
 * 									&storage.TagFilterArgs{
 * 										Name:  pulumi.String("tag2"),
 * 										Op:    pulumi.String("=="),
 * 										Value: pulumi.String("val2"),
 * 									},
 * 								},
 * 								BlobTypes: pulumi.StringArray{
 * 									pulumi.String("blockBlob"),
 * 								},
 * 								PrefixMatch: pulumi.StringArray{
 * 									pulumi.String("olcmtestcontainer2"),
 * 								},
 * 							},
 * 						},
 * 						Enabled: pulumi.Bool(true),
 * 						Name:    pulumi.String("olcmtest2"),
 * 						Type:    pulumi.String(storage.RuleTypeLifecycle),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res7687"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.ManagementPolicySchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(ManagementPolicySchemaArgs.builder()
 *                 .rules(
 *                     ManagementPolicyRuleArgs.builder()
 *                         .definition(ManagementPolicyDefinitionArgs.builder()
 *                             .actions(ManagementPolicyActionArgs.builder()
 *                                 .baseBlob(ManagementPolicyBaseBlobArgs.builder()
 *                                     .delete(DateAfterModificationArgs.builder()
 *                                         .daysAfterModificationGreaterThan(1000)
 *                                         .build())
 *                                     .tierToArchive(DateAfterModificationArgs.builder()
 *                                         .daysAfterModificationGreaterThan(90)
 *                                         .build())
 *                                     .tierToCool(DateAfterModificationArgs.builder()
 *                                         .daysAfterModificationGreaterThan(30)
 *                                         .build())
 *                                     .build())
 *                                 .snapshot(ManagementPolicySnapShotArgs.builder()
 *                                     .delete(DateAfterCreationArgs.builder()
 *                                         .daysAfterCreationGreaterThan(30)
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .filters(ManagementPolicyFilterArgs.builder()
 *                                 .blobTypes("blockBlob")
 *                                 .prefixMatch("olcmtestcontainer1")
 *                                 .build())
 *                             .build())
 *                         .enabled(true)
 *                         .name("olcmtest1")
 *                         .type("Lifecycle")
 *                         .build(),
 *                     ManagementPolicyRuleArgs.builder()
 *                         .definition(ManagementPolicyDefinitionArgs.builder()
 *                             .actions(ManagementPolicyActionArgs.builder()
 *                                 .baseBlob(ManagementPolicyBaseBlobArgs.builder()
 *                                     .delete(DateAfterModificationArgs.builder()
 *                                         .daysAfterModificationGreaterThan(1000)
 *                                         .build())
 *                                     .tierToArchive(DateAfterModificationArgs.builder()
 *                                         .daysAfterModificationGreaterThan(90)
 *                                         .build())
 *                                     .tierToCool(DateAfterModificationArgs.builder()
 *                                         .daysAfterModificationGreaterThan(30)
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .filters(ManagementPolicyFilterArgs.builder()
 *                                 .blobIndexMatch(
 *                                     TagFilterArgs.builder()
 *                                         .name("tag1")
 *                                         .op("==")
 *                                         .value("val1")
 *                                         .build(),
 *                                     TagFilterArgs.builder()
 *                                         .name("tag2")
 *                                         .op("==")
 *                                         .value("val2")
 *                                         .build())
 *                                 .blobTypes("blockBlob")
 *                                 .prefixMatch("olcmtestcontainer2")
 *                                 .build())
 *                             .build())
 *                         .enabled(true)
 *                         .name("olcmtest2")
 *                         .type("Lifecycle")
 *                         .build())
 *                 .build())
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetManagementPolicyColdTierActions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 90,
 *                                 },
 *                                 TierToCold = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 30,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Snapshot = new AzureNative.Storage.Inputs.ManagementPolicySnapShotArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                                 TierToCold = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Version = new AzureNative.Storage.Inputs.ManagementPolicyVersionArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                                 TierToCold = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer1",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest1",
 *                     Type = AzureNative.Storage.RuleType.Lifecycle,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * 			AccountName:          pulumi.String("sto9699"),
 * 			ManagementPolicyName: pulumi.String("default"),
 * 			Policy: &storage.ManagementPolicySchemaArgs{
 * 				Rules: storage.ManagementPolicyRuleArray{
 * 					&storage.ManagementPolicyRuleArgs{
 * 						Definition: &storage.ManagementPolicyDefinitionArgs{
 * 							Actions: &storage.ManagementPolicyActionArgs{
 * 								BaseBlob: &storage.ManagementPolicyBaseBlobArgs{
 * 									Delete: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(1000),
 * 									},
 * 									TierToArchive: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(90),
 * 									},
 * 									TierToCold: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(30),
 * 									},
 * 									TierToCool: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 								Snapshot: &storage.ManagementPolicySnapShotArgs{
 * 									Delete: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * 									},
 * 									TierToCold: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 								Version: &storage.ManagementPolicyVersionArgs{
 * 									Delete: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * 									},
 * 									TierToCold: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 							},
 * 							Filters: &storage.ManagementPolicyFilterArgs{
 * 								BlobTypes: pulumi.StringArray{
 * 									pulumi.String("blockBlob"),
 * 								},
 * 								PrefixMatch: pulumi.StringArray{
 * 									pulumi.String("olcmtestcontainer1"),
 * 								},
 * 							},
 * 						},
 * 						Enabled: pulumi.Bool(true),
 * 						Name:    pulumi.String("olcmtest1"),
 * 						Type:    pulumi.String(storage.RuleTypeLifecycle),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res7687"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.ManagementPolicySchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(ManagementPolicySchemaArgs.builder()
 *                 .rules(ManagementPolicyRuleArgs.builder()
 *                     .definition(ManagementPolicyDefinitionArgs.builder()
 *                         .actions(ManagementPolicyActionArgs.builder()
 *                             .baseBlob(ManagementPolicyBaseBlobArgs.builder()
 *                                 .delete(DateAfterModificationArgs.builder()
 *                                     .daysAfterModificationGreaterThan(1000)
 *                                     .build())
 *                                 .tierToArchive(DateAfterModificationArgs.builder()
 *                                     .daysAfterModificationGreaterThan(90)
 *                                     .build())
 *                                 .tierToCold(DateAfterModificationArgs.builder()
 *                                     .daysAfterModificationGreaterThan(30)
 *                                     .build())
 *                                 .tierToCool(DateAfterModificationArgs.builder()
 *                                     .daysAfterModificationGreaterThan(30)
 *                                     .build())
 *                                 .build())
 *                             .snapshot(ManagementPolicySnapShotArgs.builder()
 *                                 .delete(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(30)
 *                                     .build())
 *                                 .tierToCold(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(30)
 *                                     .build())
 *                                 .build())
 *                             .version(ManagementPolicyVersionArgs.builder()
 *                                 .delete(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(30)
 *                                     .build())
 *                                 .tierToCold(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(30)
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .filters(ManagementPolicyFilterArgs.builder()
 *                             .blobTypes("blockBlob")
 *                             .prefixMatch("olcmtestcontainer1")
 *                             .build())
 *                         .build())
 *                     .enabled(true)
 *                     .name("olcmtest1")
 *                     .type("Lifecycle")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetManagementPolicyForBlockAndAppendBlobs
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 90,
 *                                 },
 *                             },
 *                             Snapshot = new AzureNative.Storage.Inputs.ManagementPolicySnapShotArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 90,
 *                                 },
 *                             },
 *                             Version = new AzureNative.Storage.Inputs.ManagementPolicyVersionArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 90,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                                 "appendBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer1",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest1",
 *                     Type = AzureNative.Storage.RuleType.Lifecycle,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * 			AccountName:          pulumi.String("sto9699"),
 * 			ManagementPolicyName: pulumi.String("default"),
 * 			Policy: &storage.ManagementPolicySchemaArgs{
 * 				Rules: storage.ManagementPolicyRuleArray{
 * 					&storage.ManagementPolicyRuleArgs{
 * 						Definition: &storage.ManagementPolicyDefinitionArgs{
 * 							Actions: &storage.ManagementPolicyActionArgs{
 * 								BaseBlob: &storage.ManagementPolicyBaseBlobArgs{
 * 									Delete: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(90),
 * 									},
 * 								},
 * 								Snapshot: &storage.ManagementPolicySnapShotArgs{
 * 									Delete: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(90),
 * 									},
 * 								},
 * 								Version: &storage.ManagementPolicyVersionArgs{
 * 									Delete: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(90),
 * 									},
 * 								},
 * 							},
 * 							Filters: &storage.ManagementPolicyFilterArgs{
 * 								BlobTypes: pulumi.StringArray{
 * 									pulumi.String("blockBlob"),
 * 									pulumi.String("appendBlob"),
 * 								},
 * 								PrefixMatch: pulumi.StringArray{
 * 									pulumi.String("olcmtestcontainer1"),
 * 								},
 * 							},
 * 						},
 * 						Enabled: pulumi.Bool(true),
 * 						Name:    pulumi.String("olcmtest1"),
 * 						Type:    pulumi.String(storage.RuleTypeLifecycle),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res7687"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.ManagementPolicySchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(ManagementPolicySchemaArgs.builder()
 *                 .rules(ManagementPolicyRuleArgs.builder()
 *                     .definition(ManagementPolicyDefinitionArgs.builder()
 *                         .actions(ManagementPolicyActionArgs.builder()
 *                             .baseBlob(ManagementPolicyBaseBlobArgs.builder()
 *                                 .delete(DateAfterModificationArgs.builder()
 *                                     .daysAfterModificationGreaterThan(90)
 *                                     .build())
 *                                 .build())
 *                             .snapshot(ManagementPolicySnapShotArgs.builder()
 *                                 .delete(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(90)
 *                                     .build())
 *                                 .build())
 *                             .version(ManagementPolicyVersionArgs.builder()
 *                                 .delete(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(90)
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .filters(ManagementPolicyFilterArgs.builder()
 *                             .blobTypes(
 *                                 "blockBlob",
 *                                 "appendBlob")
 *                             .prefixMatch("olcmtestcontainer1")
 *                             .build())
 *                         .build())
 *                     .enabled(true)
 *                     .name("olcmtest1")
 *                     .type("Lifecycle")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetManagementPolicyHotTierActions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 TierToHot = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Snapshot = new AzureNative.Storage.Inputs.ManagementPolicySnapShotArgs
 *                             {
 *                                 TierToHot = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Version = new AzureNative.Storage.Inputs.ManagementPolicyVersionArgs
 *                             {
 *                                 TierToHot = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer1",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest1",
 *                     Type = AzureNative.Storage.RuleType.Lifecycle,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * 			AccountName:          pulumi.String("sto9699"),
 * 			ManagementPolicyName: pulumi.String("default"),
 * 			Policy: &storage.ManagementPolicySchemaArgs{
 * 				Rules: storage.ManagementPolicyRuleArray{
 * 					&storage.ManagementPolicyRuleArgs{
 * 						Definition: &storage.ManagementPolicyDefinitionArgs{
 * 							Actions: &storage.ManagementPolicyActionArgs{
 * 								BaseBlob: &storage.ManagementPolicyBaseBlobArgs{
 * 									TierToHot: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 								Snapshot: &storage.ManagementPolicySnapShotArgs{
 * 									TierToHot: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 								Version: &storage.ManagementPolicyVersionArgs{
 * 									TierToHot: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 							},
 * 							Filters: &storage.ManagementPolicyFilterArgs{
 * 								BlobTypes: pulumi.StringArray{
 * 									pulumi.String("blockBlob"),
 * 								},
 * 								PrefixMatch: pulumi.StringArray{
 * 									pulumi.String("olcmtestcontainer1"),
 * 								},
 * 							},
 * 						},
 * 						Enabled: pulumi.Bool(true),
 * 						Name:    pulumi.String("olcmtest1"),
 * 						Type:    pulumi.String(storage.RuleTypeLifecycle),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res7687"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.ManagementPolicySchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(ManagementPolicySchemaArgs.builder()
 *                 .rules(ManagementPolicyRuleArgs.builder()
 *                     .definition(ManagementPolicyDefinitionArgs.builder()
 *                         .actions(ManagementPolicyActionArgs.builder()
 *                             .baseBlob(ManagementPolicyBaseBlobArgs.builder()
 *                                 .tierToHot(DateAfterModificationArgs.builder()
 *                                     .daysAfterModificationGreaterThan(30)
 *                                     .build())
 *                                 .build())
 *                             .snapshot(ManagementPolicySnapShotArgs.builder()
 *                                 .tierToHot(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(30)
 *                                     .build())
 *                                 .build())
 *                             .version(ManagementPolicyVersionArgs.builder()
 *                                 .tierToHot(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(30)
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .filters(ManagementPolicyFilterArgs.builder()
 *                             .blobTypes("blockBlob")
 *                             .prefixMatch("olcmtestcontainer1")
 *                             .build())
 *                         .build())
 *                     .enabled(true)
 *                     .name("olcmtest1")
 *                     .type("Lifecycle")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetManagementPolicyWithSnapshotAndVersion
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Snapshot = new AzureNative.Storage.Inputs.ManagementPolicySnapShotArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Version = new AzureNative.Storage.Inputs.ManagementPolicyVersionArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer1",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest1",
 *                     Type = AzureNative.Storage.RuleType.Lifecycle,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * 			AccountName:          pulumi.String("sto9699"),
 * 			ManagementPolicyName: pulumi.String("default"),
 * 			Policy: &storage.ManagementPolicySchemaArgs{
 * 				Rules: storage.ManagementPolicyRuleArray{
 * 					&storage.ManagementPolicyRuleArgs{
 * 						Definition: &storage.ManagementPolicyDefinitionArgs{
 * 							Actions: &storage.ManagementPolicyActionArgs{
 * 								BaseBlob: &storage.ManagementPolicyBaseBlobArgs{
 * 									Delete: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(1000),
 * 									},
 * 									TierToArchive: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(90),
 * 									},
 * 									TierToCool: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 								Snapshot: &storage.ManagementPolicySnapShotArgs{
 * 									Delete: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(1000),
 * 									},
 * 									TierToArchive: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(90),
 * 									},
 * 									TierToCool: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 								Version: &storage.ManagementPolicyVersionArgs{
 * 									Delete: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(1000),
 * 									},
 * 									TierToArchive: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(90),
 * 									},
 * 									TierToCool: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 							},
 * 							Filters: &storage.ManagementPolicyFilterArgs{
 * 								BlobTypes: pulumi.StringArray{
 * 									pulumi.String("blockBlob"),
 * 								},
 * 								PrefixMatch: pulumi.StringArray{
 * 									pulumi.String("olcmtestcontainer1"),
 * 								},
 * 							},
 * 						},
 * 						Enabled: pulumi.Bool(true),
 * 						Name:    pulumi.String("olcmtest1"),
 * 						Type:    pulumi.String(storage.RuleTypeLifecycle),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res7687"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.ManagementPolicySchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(ManagementPolicySchemaArgs.builder()
 *                 .rules(ManagementPolicyRuleArgs.builder()
 *                     .definition(ManagementPolicyDefinitionArgs.builder()
 *                         .actions(ManagementPolicyActionArgs.builder()
 *                             .baseBlob(ManagementPolicyBaseBlobArgs.builder()
 *                                 .delete(DateAfterModificationArgs.builder()
 *                                     .daysAfterModificationGreaterThan(1000)
 *                                     .build())
 *                                 .tierToArchive(DateAfterModificationArgs.builder()
 *                                     .daysAfterModificationGreaterThan(90)
 *                                     .build())
 *                                 .tierToCool(DateAfterModificationArgs.builder()
 *                                     .daysAfterModificationGreaterThan(30)
 *                                     .build())
 *                                 .build())
 *                             .snapshot(ManagementPolicySnapShotArgs.builder()
 *                                 .delete(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(1000)
 *                                     .build())
 *                                 .tierToArchive(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(90)
 *                                     .build())
 *                                 .tierToCool(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(30)
 *                                     .build())
 *                                 .build())
 *                             .version(ManagementPolicyVersionArgs.builder()
 *                                 .delete(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(1000)
 *                                     .build())
 *                                 .tierToArchive(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(90)
 *                                     .build())
 *                                 .tierToCool(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(30)
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .filters(ManagementPolicyFilterArgs.builder()
 *                             .blobTypes("blockBlob")
 *                             .prefixMatch("olcmtestcontainer1")
 *                             .build())
 *                         .build())
 *                     .enabled(true)
 *                     .name("olcmtest1")
 *                     .type("Lifecycle")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetManagementPolicy_BaseBlobDaysAfterCreationActions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer1",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest1",
 *                     Type = AzureNative.Storage.RuleType.Lifecycle,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * 			AccountName:          pulumi.String("sto9699"),
 * 			ManagementPolicyName: pulumi.String("default"),
 * 			Policy: &storage.ManagementPolicySchemaArgs{
 * 				Rules: storage.ManagementPolicyRuleArray{
 * 					&storage.ManagementPolicyRuleArgs{
 * 						Definition: &storage.ManagementPolicyDefinitionArgs{
 * 							Actions: &storage.ManagementPolicyActionArgs{
 * 								BaseBlob: &storage.ManagementPolicyBaseBlobArgs{
 * 									Delete: &storage.DateAfterModificationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(1000),
 * 									},
 * 									TierToArchive: &storage.DateAfterModificationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(90),
 * 									},
 * 									TierToCool: &storage.DateAfterModificationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 							},
 * 							Filters: &storage.ManagementPolicyFilterArgs{
 * 								BlobTypes: pulumi.StringArray{
 * 									pulumi.String("blockBlob"),
 * 								},
 * 								PrefixMatch: pulumi.StringArray{
 * 									pulumi.String("olcmtestcontainer1"),
 * 								},
 * 							},
 * 						},
 * 						Enabled: pulumi.Bool(true),
 * 						Name:    pulumi.String("olcmtest1"),
 * 						Type:    pulumi.String(storage.RuleTypeLifecycle),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res7687"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.ManagementPolicySchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(ManagementPolicySchemaArgs.builder()
 *                 .rules(ManagementPolicyRuleArgs.builder()
 *                     .definition(ManagementPolicyDefinitionArgs.builder()
 *                         .actions(ManagementPolicyActionArgs.builder()
 *                             .baseBlob(ManagementPolicyBaseBlobArgs.builder()
 *                                 .delete(DateAfterModificationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(1000)
 *                                     .build())
 *                                 .tierToArchive(DateAfterModificationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(90)
 *                                     .build())
 *                                 .tierToCool(DateAfterModificationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(30)
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .filters(ManagementPolicyFilterArgs.builder()
 *                             .blobTypes("blockBlob")
 *                             .prefixMatch("olcmtestcontainer1")
 *                             .build())
 *                         .build())
 *                     .enabled(true)
 *                     .name("olcmtest1")
 *                     .type("Lifecycle")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetManagementPolicy_LastAccessTimeBasedBlobActions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterLastAccessTimeGreaterThan = 1000,
 *                                 },
 *                                 EnableAutoTierToHotFromCool = true,
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterLastAccessTimeGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterLastAccessTimeGreaterThan = 30,
 *                                 },
 *                             },
 *                             Snapshot = new AzureNative.Storage.Inputs.ManagementPolicySnapShotArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest",
 *                     Type = AzureNative.Storage.RuleType.Lifecycle,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * 			AccountName:          pulumi.String("sto9699"),
 * 			ManagementPolicyName: pulumi.String("default"),
 * 			Policy: &storage.ManagementPolicySchemaArgs{
 * 				Rules: storage.ManagementPolicyRuleArray{
 * 					&storage.ManagementPolicyRuleArgs{
 * 						Definition: &storage.ManagementPolicyDefinitionArgs{
 * 							Actions: &storage.ManagementPolicyActionArgs{
 * 								BaseBlob: &storage.ManagementPolicyBaseBlobArgs{
 * 									Delete: &storage.DateAfterModificationArgs{
 * 										DaysAfterLastAccessTimeGreaterThan: pulumi.Float64(1000),
 * 									},
 * 									EnableAutoTierToHotFromCool: pulumi.Bool(true),
 * 									TierToArchive: &storage.DateAfterModificationArgs{
 * 										DaysAfterLastAccessTimeGreaterThan: pulumi.Float64(90),
 * 									},
 * 									TierToCool: &storage.DateAfterModificationArgs{
 * 										DaysAfterLastAccessTimeGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 								Snapshot: &storage.ManagementPolicySnapShotArgs{
 * 									Delete: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 							},
 * 							Filters: &storage.ManagementPolicyFilterArgs{
 * 								BlobTypes: pulumi.StringArray{
 * 									pulumi.String("blockBlob"),
 * 								},
 * 								PrefixMatch: pulumi.StringArray{
 * 									pulumi.String("olcmtestcontainer"),
 * 								},
 * 							},
 * 						},
 * 						Enabled: pulumi.Bool(true),
 * 						Name:    pulumi.String("olcmtest"),
 * 						Type:    pulumi.String(storage.RuleTypeLifecycle),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res7687"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.ManagementPolicySchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(ManagementPolicySchemaArgs.builder()
 *                 .rules(ManagementPolicyRuleArgs.builder()
 *                     .definition(ManagementPolicyDefinitionArgs.builder()
 *                         .actions(ManagementPolicyActionArgs.builder()
 *                             .baseBlob(ManagementPolicyBaseBlobArgs.builder()
 *                                 .delete(DateAfterModificationArgs.builder()
 *                                     .daysAfterLastAccessTimeGreaterThan(1000)
 *                                     .build())
 *                                 .enableAutoTierToHotFromCool(true)
 *                                 .tierToArchive(DateAfterModificationArgs.builder()
 *                                     .daysAfterLastAccessTimeGreaterThan(90)
 *                                     .build())
 *                                 .tierToCool(DateAfterModificationArgs.builder()
 *                                     .daysAfterLastAccessTimeGreaterThan(30)
 *                                     .build())
 *                                 .build())
 *                             .snapshot(ManagementPolicySnapShotArgs.builder()
 *                                 .delete(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(30)
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .filters(ManagementPolicyFilterArgs.builder()
 *                             .blobTypes("blockBlob")
 *                             .prefixMatch("olcmtestcontainer")
 *                             .build())
 *                         .build())
 *                     .enabled(true)
 *                     .name("olcmtest")
 *                     .type("Lifecycle")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetManagementPolicy_LastTierChangeTimeActions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementPolicy = new AzureNative.Storage.ManagementPolicy("managementPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         ManagementPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.ManagementPolicySchemaArgs
 *         {
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.ManagementPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.ManagementPolicyDefinitionArgs
 *                     {
 *                         Actions = new AzureNative.Storage.Inputs.ManagementPolicyActionArgs
 *                         {
 *                             BaseBlob = new AzureNative.Storage.Inputs.ManagementPolicyBaseBlobArgs
 *                             {
 *                                 Delete = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 1000,
 *                                 },
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterLastTierChangeGreaterThan = 120,
 *                                     DaysAfterModificationGreaterThan = 90,
 *                                 },
 *                                 TierToCool = new AzureNative.Storage.Inputs.DateAfterModificationArgs
 *                                 {
 *                                     DaysAfterModificationGreaterThan = 30,
 *                                 },
 *                             },
 *                             Snapshot = new AzureNative.Storage.Inputs.ManagementPolicySnapShotArgs
 *                             {
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                     DaysAfterLastTierChangeGreaterThan = 90,
 *                                 },
 *                             },
 *                             Version = new AzureNative.Storage.Inputs.ManagementPolicyVersionArgs
 *                             {
 *                                 TierToArchive = new AzureNative.Storage.Inputs.DateAfterCreationArgs
 *                                 {
 *                                     DaysAfterCreationGreaterThan = 30,
 *                                     DaysAfterLastTierChangeGreaterThan = 90,
 *                                 },
 *                             },
 *                         },
 *                         Filters = new AzureNative.Storage.Inputs.ManagementPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                             },
 *                             PrefixMatch = new[]
 *                             {
 *                                 "olcmtestcontainer",
 *                             },
 *                         },
 *                     },
 *                     Enabled = true,
 *                     Name = "olcmtest",
 *                     Type = AzureNative.Storage.RuleType.Lifecycle,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewManagementPolicy(ctx, "managementPolicy", &storage.ManagementPolicyArgs{
 * 			AccountName:          pulumi.String("sto9699"),
 * 			ManagementPolicyName: pulumi.String("default"),
 * 			Policy: &storage.ManagementPolicySchemaArgs{
 * 				Rules: storage.ManagementPolicyRuleArray{
 * 					&storage.ManagementPolicyRuleArgs{
 * 						Definition: &storage.ManagementPolicyDefinitionArgs{
 * 							Actions: &storage.ManagementPolicyActionArgs{
 * 								BaseBlob: &storage.ManagementPolicyBaseBlobArgs{
 * 									Delete: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(1000),
 * 									},
 * 									TierToArchive: &storage.DateAfterModificationArgs{
 * 										DaysAfterLastTierChangeGreaterThan: pulumi.Float64(120),
 * 										DaysAfterModificationGreaterThan:   pulumi.Float64(90),
 * 									},
 * 									TierToCool: &storage.DateAfterModificationArgs{
 * 										DaysAfterModificationGreaterThan: pulumi.Float64(30),
 * 									},
 * 								},
 * 								Snapshot: &storage.ManagementPolicySnapShotArgs{
 * 									TierToArchive: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan:       pulumi.Float64(30),
 * 										DaysAfterLastTierChangeGreaterThan: pulumi.Float64(90),
 * 									},
 * 								},
 * 								Version: &storage.ManagementPolicyVersionArgs{
 * 									TierToArchive: &storage.DateAfterCreationArgs{
 * 										DaysAfterCreationGreaterThan:       pulumi.Float64(30),
 * 										DaysAfterLastTierChangeGreaterThan: pulumi.Float64(90),
 * 									},
 * 								},
 * 							},
 * 							Filters: &storage.ManagementPolicyFilterArgs{
 * 								BlobTypes: pulumi.StringArray{
 * 									pulumi.String("blockBlob"),
 * 								},
 * 								PrefixMatch: pulumi.StringArray{
 * 									pulumi.String("olcmtestcontainer"),
 * 								},
 * 							},
 * 						},
 * 						Enabled: pulumi.Bool(true),
 * 						Name:    pulumi.String("olcmtest"),
 * 						Type:    pulumi.String(storage.RuleTypeLifecycle),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res7687"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ManagementPolicy;
 * import com.pulumi.azurenative.storage.ManagementPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.ManagementPolicySchemaArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementPolicy = new ManagementPolicy("managementPolicy", ManagementPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .managementPolicyName("default")
 *             .policy(ManagementPolicySchemaArgs.builder()
 *                 .rules(ManagementPolicyRuleArgs.builder()
 *                     .definition(ManagementPolicyDefinitionArgs.builder()
 *                         .actions(ManagementPolicyActionArgs.builder()
 *                             .baseBlob(ManagementPolicyBaseBlobArgs.builder()
 *                                 .delete(DateAfterModificationArgs.builder()
 *                                     .daysAfterModificationGreaterThan(1000)
 *                                     .build())
 *                                 .tierToArchive(DateAfterModificationArgs.builder()
 *                                     .daysAfterLastTierChangeGreaterThan(120)
 *                                     .daysAfterModificationGreaterThan(90)
 *                                     .build())
 *                                 .tierToCool(DateAfterModificationArgs.builder()
 *                                     .daysAfterModificationGreaterThan(30)
 *                                     .build())
 *                                 .build())
 *                             .snapshot(ManagementPolicySnapShotArgs.builder()
 *                                 .tierToArchive(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(30)
 *                                     .daysAfterLastTierChangeGreaterThan(90)
 *                                     .build())
 *                                 .build())
 *                             .version(ManagementPolicyVersionArgs.builder()
 *                                 .tierToArchive(DateAfterCreationArgs.builder()
 *                                     .daysAfterCreationGreaterThan(30)
 *                                     .daysAfterLastTierChangeGreaterThan(90)
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .filters(ManagementPolicyFilterArgs.builder()
 *                             .blobTypes("blockBlob")
 *                             .prefixMatch("olcmtestcontainer")
 *                             .build())
 *                         .build())
 *                     .enabled(true)
 *                     .name("olcmtest")
 *                     .type("Lifecycle")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:ManagementPolicy DefaultManagementPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/managementPolicies/{managementPolicyName}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property managementPolicyName The name of the Storage Account Management Policy. It should always be 'default'
 * @property policy The Storage Account ManagementPolicy, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class ManagementPolicyArgs(
    public val accountName: Output<String>? = null,
    public val managementPolicyName: Output<String>? = null,
    public val policy: Output<ManagementPolicySchemaArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.ManagementPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.ManagementPolicyArgs =
        com.pulumi.azurenative.storage.ManagementPolicyArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .managementPolicyName(managementPolicyName?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagementPolicyArgs].
 */
@PulumiTagMarker
public class ManagementPolicyArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var managementPolicyName: Output<String>? = null

    private var policy: Output<ManagementPolicySchemaArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("pvswrmjjesfrdoko")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the Storage Account Management Policy. It should always be 'default'
     */
    @JvmName("kwymeqhfoeicjpdl")
    public suspend fun managementPolicyName(`value`: Output<String>) {
        this.managementPolicyName = value
    }

    /**
     * @param value The Storage Account ManagementPolicy, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     */
    @JvmName("rtvecinppnkcymuk")
    public suspend fun policy(`value`: Output<ManagementPolicySchemaArgs>) {
        this.policy = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("alosepebgthevpcw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("nvtkbhmjmboxkhkl")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Storage Account Management Policy. It should always be 'default'
     */
    @JvmName("jgactanlwecpqrfs")
    public suspend fun managementPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementPolicyName = mapped
    }

    /**
     * @param value The Storage Account ManagementPolicy, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     */
    @JvmName("vhbjggtfeiprmwdk")
    public suspend fun policy(`value`: ManagementPolicySchemaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument The Storage Account ManagementPolicy, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
     */
    @JvmName("gtdgkkqwlumkqcmt")
    public suspend fun policy(argument: suspend ManagementPolicySchemaArgsBuilder.() -> Unit) {
        val toBeMapped = ManagementPolicySchemaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("tuskufxekyoetels")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ManagementPolicyArgs = ManagementPolicyArgs(
        accountName = accountName,
        managementPolicyName = managementPolicyName,
        policy = policy,
        resourceGroupName = resourceGroupName,
    )
}
