@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.kotlin.outputs.ObjectReplicationPolicyRuleResponse
import com.pulumi.azurenative.storage.kotlin.outputs.ObjectReplicationPolicyRuleResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ObjectReplicationPolicy].
 */
@PulumiTagMarker
public class ObjectReplicationPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ObjectReplicationPolicyArgs = ObjectReplicationPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ObjectReplicationPolicyArgsBuilder.() -> Unit) {
        val builder = ObjectReplicationPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ObjectReplicationPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.storage.ObjectReplicationPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ObjectReplicationPolicy(builtJavaResource)
    }
}

/**
 * The replication policy between two storage accounts. Multiple rules can be defined in one policy.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01, 2023-04-01.
 * ## Example Usage
 * ### StorageAccountCreateObjectReplicationPolicyOnDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var objectReplicationPolicy = new AzureNative.Storage.ObjectReplicationPolicy("objectReplicationPolicy", new()
 *     {
 *         AccountName = "dst112",
 *         DestinationAccount = "dst112",
 *         ObjectReplicationPolicyId = "default",
 *         ResourceGroupName = "res7687",
 *         Rules = new[]
 *         {
 *             new AzureNative.Storage.Inputs.ObjectReplicationPolicyRuleArgs
 *             {
 *                 DestinationContainer = "dcont139",
 *                 Filters = new AzureNative.Storage.Inputs.ObjectReplicationPolicyFilterArgs
 *                 {
 *                     PrefixMatch = new[]
 *                     {
 *                         "blobA",
 *                         "blobB",
 *                     },
 *                 },
 *                 SourceContainer = "scont139",
 *             },
 *         },
 *         SourceAccount = "src1122",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewObjectReplicationPolicy(ctx, "objectReplicationPolicy", &storage.ObjectReplicationPolicyArgs{
 * 			AccountName:               pulumi.String("dst112"),
 * 			DestinationAccount:        pulumi.String("dst112"),
 * 			ObjectReplicationPolicyId: pulumi.String("default"),
 * 			ResourceGroupName:         pulumi.String("res7687"),
 * 			Rules: storage.ObjectReplicationPolicyRuleArray{
 * 				&storage.ObjectReplicationPolicyRuleArgs{
 * 					DestinationContainer: pulumi.String("dcont139"),
 * 					Filters: &storage.ObjectReplicationPolicyFilterArgs{
 * 						PrefixMatch: pulumi.StringArray{
 * 							pulumi.String("blobA"),
 * 							pulumi.String("blobB"),
 * 						},
 * 					},
 * 					SourceContainer: pulumi.String("scont139"),
 * 				},
 * 			},
 * 			SourceAccount: pulumi.String("src1122"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicy;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyRuleArgs;
 * import com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var objectReplicationPolicy = new ObjectReplicationPolicy("objectReplicationPolicy", ObjectReplicationPolicyArgs.builder()
 *             .accountName("dst112")
 *             .destinationAccount("dst112")
 *             .objectReplicationPolicyId("default")
 *             .resourceGroupName("res7687")
 *             .rules(ObjectReplicationPolicyRuleArgs.builder()
 *                 .destinationContainer("dcont139")
 *                 .filters(ObjectReplicationPolicyFilterArgs.builder()
 *                     .prefixMatch(
 *                         "blobA",
 *                         "blobB")
 *                     .build())
 *                 .sourceContainer("scont139")
 *                 .build())
 *             .sourceAccount("src1122")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateObjectReplicationPolicyOnSource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var objectReplicationPolicy = new AzureNative.Storage.ObjectReplicationPolicy("objectReplicationPolicy", new()
 *     {
 *         AccountName = "src1122",
 *         DestinationAccount = "dst112",
 *         ObjectReplicationPolicyId = "2a20bb73-5717-4635-985a-5d4cf777438f",
 *         ResourceGroupName = "res7687",
 *         Rules = new[]
 *         {
 *             new AzureNative.Storage.Inputs.ObjectReplicationPolicyRuleArgs
 *             {
 *                 DestinationContainer = "dcont139",
 *                 Filters = new AzureNative.Storage.Inputs.ObjectReplicationPolicyFilterArgs
 *                 {
 *                     MinCreationTime = "2020-02-19T16:05:00Z",
 *                     PrefixMatch = new[]
 *                     {
 *                         "blobA",
 *                         "blobB",
 *                     },
 *                 },
 *                 RuleId = "d5d18a48-8801-4554-aeaa-74faf65f5ef9",
 *                 SourceContainer = "scont139",
 *             },
 *         },
 *         SourceAccount = "src1122",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewObjectReplicationPolicy(ctx, "objectReplicationPolicy", &storage.ObjectReplicationPolicyArgs{
 * 			AccountName:               pulumi.String("src1122"),
 * 			DestinationAccount:        pulumi.String("dst112"),
 * 			ObjectReplicationPolicyId: pulumi.String("2a20bb73-5717-4635-985a-5d4cf777438f"),
 * 			ResourceGroupName:         pulumi.String("res7687"),
 * 			Rules: storage.ObjectReplicationPolicyRuleArray{
 * 				&storage.ObjectReplicationPolicyRuleArgs{
 * 					DestinationContainer: pulumi.String("dcont139"),
 * 					Filters: &storage.ObjectReplicationPolicyFilterArgs{
 * 						MinCreationTime: pulumi.String("2020-02-19T16:05:00Z"),
 * 						PrefixMatch: pulumi.StringArray{
 * 							pulumi.String("blobA"),
 * 							pulumi.String("blobB"),
 * 						},
 * 					},
 * 					RuleId:          pulumi.String("d5d18a48-8801-4554-aeaa-74faf65f5ef9"),
 * 					SourceContainer: pulumi.String("scont139"),
 * 				},
 * 			},
 * 			SourceAccount: pulumi.String("src1122"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicy;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyRuleArgs;
 * import com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var objectReplicationPolicy = new ObjectReplicationPolicy("objectReplicationPolicy", ObjectReplicationPolicyArgs.builder()
 *             .accountName("src1122")
 *             .destinationAccount("dst112")
 *             .objectReplicationPolicyId("2a20bb73-5717-4635-985a-5d4cf777438f")
 *             .resourceGroupName("res7687")
 *             .rules(ObjectReplicationPolicyRuleArgs.builder()
 *                 .destinationContainer("dcont139")
 *                 .filters(ObjectReplicationPolicyFilterArgs.builder()
 *                     .minCreationTime("2020-02-19T16:05:00Z")
 *                     .prefixMatch(
 *                         "blobA",
 *                         "blobB")
 *                     .build())
 *                 .ruleId("d5d18a48-8801-4554-aeaa-74faf65f5ef9")
 *                 .sourceContainer("scont139")
 *                 .build())
 *             .sourceAccount("src1122")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountUpdateObjectReplicationPolicyOnDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var objectReplicationPolicy = new AzureNative.Storage.ObjectReplicationPolicy("objectReplicationPolicy", new()
 *     {
 *         AccountName = "dst112",
 *         DestinationAccount = "dst112",
 *         ObjectReplicationPolicyId = "2a20bb73-5717-4635-985a-5d4cf777438f",
 *         ResourceGroupName = "res7687",
 *         Rules = new[]
 *         {
 *             new AzureNative.Storage.Inputs.ObjectReplicationPolicyRuleArgs
 *             {
 *                 DestinationContainer = "dcont139",
 *                 Filters = new AzureNative.Storage.Inputs.ObjectReplicationPolicyFilterArgs
 *                 {
 *                     PrefixMatch = new[]
 *                     {
 *                         "blobA",
 *                         "blobB",
 *                     },
 *                 },
 *                 RuleId = "d5d18a48-8801-4554-aeaa-74faf65f5ef9",
 *                 SourceContainer = "scont139",
 *             },
 *             new AzureNative.Storage.Inputs.ObjectReplicationPolicyRuleArgs
 *             {
 *                 DestinationContainer = "dcont179",
 *                 SourceContainer = "scont179",
 *             },
 *         },
 *         SourceAccount = "src1122",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewObjectReplicationPolicy(ctx, "objectReplicationPolicy", &storage.ObjectReplicationPolicyArgs{
 * 			AccountName:               pulumi.String("dst112"),
 * 			DestinationAccount:        pulumi.String("dst112"),
 * 			ObjectReplicationPolicyId: pulumi.String("2a20bb73-5717-4635-985a-5d4cf777438f"),
 * 			ResourceGroupName:         pulumi.String("res7687"),
 * 			Rules: storage.ObjectReplicationPolicyRuleArray{
 * 				&storage.ObjectReplicationPolicyRuleArgs{
 * 					DestinationContainer: pulumi.String("dcont139"),
 * 					Filters: &storage.ObjectReplicationPolicyFilterArgs{
 * 						PrefixMatch: pulumi.StringArray{
 * 							pulumi.String("blobA"),
 * 							pulumi.String("blobB"),
 * 						},
 * 					},
 * 					RuleId:          pulumi.String("d5d18a48-8801-4554-aeaa-74faf65f5ef9"),
 * 					SourceContainer: pulumi.String("scont139"),
 * 				},
 * 				&storage.ObjectReplicationPolicyRuleArgs{
 * 					DestinationContainer: pulumi.String("dcont179"),
 * 					SourceContainer:      pulumi.String("scont179"),
 * 				},
 * 			},
 * 			SourceAccount: pulumi.String("src1122"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicy;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyRuleArgs;
 * import com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var objectReplicationPolicy = new ObjectReplicationPolicy("objectReplicationPolicy", ObjectReplicationPolicyArgs.builder()
 *             .accountName("dst112")
 *             .destinationAccount("dst112")
 *             .objectReplicationPolicyId("2a20bb73-5717-4635-985a-5d4cf777438f")
 *             .resourceGroupName("res7687")
 *             .rules(
 *                 ObjectReplicationPolicyRuleArgs.builder()
 *                     .destinationContainer("dcont139")
 *                     .filters(ObjectReplicationPolicyFilterArgs.builder()
 *                         .prefixMatch(
 *                             "blobA",
 *                             "blobB")
 *                         .build())
 *                     .ruleId("d5d18a48-8801-4554-aeaa-74faf65f5ef9")
 *                     .sourceContainer("scont139")
 *                     .build(),
 *                 ObjectReplicationPolicyRuleArgs.builder()
 *                     .destinationContainer("dcont179")
 *                     .sourceContainer("scont179")
 *                     .build())
 *             .sourceAccount("src1122")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountUpdateObjectReplicationPolicyOnSource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var objectReplicationPolicy = new AzureNative.Storage.ObjectReplicationPolicy("objectReplicationPolicy", new()
 *     {
 *         AccountName = "src1122",
 *         DestinationAccount = "dst112",
 *         ObjectReplicationPolicyId = "2a20bb73-5717-4635-985a-5d4cf777438f",
 *         ResourceGroupName = "res7687",
 *         Rules = new[]
 *         {
 *             new AzureNative.Storage.Inputs.ObjectReplicationPolicyRuleArgs
 *             {
 *                 DestinationContainer = "dcont139",
 *                 Filters = new AzureNative.Storage.Inputs.ObjectReplicationPolicyFilterArgs
 *                 {
 *                     PrefixMatch = new[]
 *                     {
 *                         "blobA",
 *                         "blobB",
 *                     },
 *                 },
 *                 RuleId = "d5d18a48-8801-4554-aeaa-74faf65f5ef9",
 *                 SourceContainer = "scont139",
 *             },
 *             new AzureNative.Storage.Inputs.ObjectReplicationPolicyRuleArgs
 *             {
 *                 DestinationContainer = "dcont179",
 *                 RuleId = "cfbb4bc2-8b60-429f-b05a-d1e0942b33b2",
 *                 SourceContainer = "scont179",
 *             },
 *         },
 *         SourceAccount = "src1122",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewObjectReplicationPolicy(ctx, "objectReplicationPolicy", &storage.ObjectReplicationPolicyArgs{
 * 			AccountName:               pulumi.String("src1122"),
 * 			DestinationAccount:        pulumi.String("dst112"),
 * 			ObjectReplicationPolicyId: pulumi.String("2a20bb73-5717-4635-985a-5d4cf777438f"),
 * 			ResourceGroupName:         pulumi.String("res7687"),
 * 			Rules: storage.ObjectReplicationPolicyRuleArray{
 * 				&storage.ObjectReplicationPolicyRuleArgs{
 * 					DestinationContainer: pulumi.String("dcont139"),
 * 					Filters: &storage.ObjectReplicationPolicyFilterArgs{
 * 						PrefixMatch: pulumi.StringArray{
 * 							pulumi.String("blobA"),
 * 							pulumi.String("blobB"),
 * 						},
 * 					},
 * 					RuleId:          pulumi.String("d5d18a48-8801-4554-aeaa-74faf65f5ef9"),
 * 					SourceContainer: pulumi.String("scont139"),
 * 				},
 * 				&storage.ObjectReplicationPolicyRuleArgs{
 * 					DestinationContainer: pulumi.String("dcont179"),
 * 					RuleId:               pulumi.String("cfbb4bc2-8b60-429f-b05a-d1e0942b33b2"),
 * 					SourceContainer:      pulumi.String("scont179"),
 * 				},
 * 			},
 * 			SourceAccount: pulumi.String("src1122"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicy;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyRuleArgs;
 * import com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var objectReplicationPolicy = new ObjectReplicationPolicy("objectReplicationPolicy", ObjectReplicationPolicyArgs.builder()
 *             .accountName("src1122")
 *             .destinationAccount("dst112")
 *             .objectReplicationPolicyId("2a20bb73-5717-4635-985a-5d4cf777438f")
 *             .resourceGroupName("res7687")
 *             .rules(
 *                 ObjectReplicationPolicyRuleArgs.builder()
 *                     .destinationContainer("dcont139")
 *                     .filters(ObjectReplicationPolicyFilterArgs.builder()
 *                         .prefixMatch(
 *                             "blobA",
 *                             "blobB")
 *                         .build())
 *                     .ruleId("d5d18a48-8801-4554-aeaa-74faf65f5ef9")
 *                     .sourceContainer("scont139")
 *                     .build(),
 *                 ObjectReplicationPolicyRuleArgs.builder()
 *                     .destinationContainer("dcont179")
 *                     .ruleId("cfbb4bc2-8b60-429f-b05a-d1e0942b33b2")
 *                     .sourceContainer("scont179")
 *                     .build())
 *             .sourceAccount("src1122")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:ObjectReplicationPolicy 2a20bb73-5717-4635-985a-5d4cf777438f /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/objectReplicationPolicies/{objectReplicationPolicyId}
 * ```
 */
public class ObjectReplicationPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.ObjectReplicationPolicy,
) : KotlinCustomResource(javaResource, ObjectReplicationPolicyMapper) {
    /**
     * Required. Destination account name. It should be full resource id if allowCrossTenantReplication set to false.
     */
    public val destinationAccount: Output<String>
        get() = javaResource.destinationAccount().applyValue({ args0 -> args0 })

    /**
     * Indicates when the policy is enabled on the source account.
     */
    public val enabledTime: Output<String>
        get() = javaResource.enabledTime().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A unique id for object replication policy.
     */
    public val policyId: Output<String>
        get() = javaResource.policyId().applyValue({ args0 -> args0 })

    /**
     * The storage account object replication rules.
     */
    public val rules: Output<List<ObjectReplicationPolicyRuleResponse>>?
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Required. Source account name. It should be full resource id if allowCrossTenantReplication set to false.
     */
    public val sourceAccount: Output<String>
        get() = javaResource.sourceAccount().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ObjectReplicationPolicyMapper : ResourceMapper<ObjectReplicationPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.ObjectReplicationPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ObjectReplicationPolicy =
        ObjectReplicationPolicy(
            javaResource as
                com.pulumi.azurenative.storage.ObjectReplicationPolicy,
        )
}

/**
 * @see [ObjectReplicationPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ObjectReplicationPolicy].
 */
public suspend fun objectReplicationPolicy(
    name: String,
    block: suspend ObjectReplicationPolicyResourceBuilder.() -> Unit,
): ObjectReplicationPolicy {
    val builder = ObjectReplicationPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ObjectReplicationPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun objectReplicationPolicy(name: String): ObjectReplicationPolicy {
    val builder = ObjectReplicationPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
