@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.kotlin.outputs.AzureFilesIdentityBasedAuthenticationResponse
import com.pulumi.azurenative.storage.kotlin.outputs.BlobRestoreStatusResponse
import com.pulumi.azurenative.storage.kotlin.outputs.CustomDomainResponse
import com.pulumi.azurenative.storage.kotlin.outputs.EncryptionResponse
import com.pulumi.azurenative.storage.kotlin.outputs.EndpointsResponse
import com.pulumi.azurenative.storage.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.storage.kotlin.outputs.GeoReplicationStatsResponse
import com.pulumi.azurenative.storage.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.storage.kotlin.outputs.ImmutableStorageAccountResponse
import com.pulumi.azurenative.storage.kotlin.outputs.KeyCreationTimeResponse
import com.pulumi.azurenative.storage.kotlin.outputs.KeyPolicyResponse
import com.pulumi.azurenative.storage.kotlin.outputs.NetworkRuleSetResponse
import com.pulumi.azurenative.storage.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.storage.kotlin.outputs.RoutingPreferenceResponse
import com.pulumi.azurenative.storage.kotlin.outputs.SasPolicyResponse
import com.pulumi.azurenative.storage.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.storage.kotlin.outputs.StorageAccountSkuConversionStatusResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.storage.kotlin.outputs.AzureFilesIdentityBasedAuthenticationResponse.Companion.toKotlin as azureFilesIdentityBasedAuthenticationResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.BlobRestoreStatusResponse.Companion.toKotlin as blobRestoreStatusResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.CustomDomainResponse.Companion.toKotlin as customDomainResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.EncryptionResponse.Companion.toKotlin as encryptionResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.EndpointsResponse.Companion.toKotlin as endpointsResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.GeoReplicationStatsResponse.Companion.toKotlin as geoReplicationStatsResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.ImmutableStorageAccountResponse.Companion.toKotlin as immutableStorageAccountResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.KeyCreationTimeResponse.Companion.toKotlin as keyCreationTimeResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.KeyPolicyResponse.Companion.toKotlin as keyPolicyResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.NetworkRuleSetResponse.Companion.toKotlin as networkRuleSetResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.RoutingPreferenceResponse.Companion.toKotlin as routingPreferenceResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.SasPolicyResponse.Companion.toKotlin as sasPolicyResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.storage.kotlin.outputs.StorageAccountSkuConversionStatusResponse.Companion.toKotlin as storageAccountSkuConversionStatusResponseToKotlin

/**
 * Builder for [StorageAccount].
 */
@PulumiTagMarker
public class StorageAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageAccountArgs = StorageAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageAccountArgsBuilder.() -> Unit) {
        val builder = StorageAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StorageAccount {
        val builtJavaResource = com.pulumi.azurenative.storage.StorageAccount(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StorageAccount(builtJavaResource)
    }
}

/**
 * The storage account.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2015-05-01-preview, 2015-06-15, 2018-11-01, 2023-01-01, 2023-04-01.
 * ## Example Usage
 * ### NfsV3AccountCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         EnableHttpsTrafficOnly = false,
 *         EnableNfsV3 = true,
 *         IsHnsEnabled = true,
 *         Kind = AzureNative.Storage.Kind.BlockBlobStorage,
 *         Location = "eastus",
 *         NetworkRuleSet = new AzureNative.Storage.Inputs.NetworkRuleSetArgs
 *         {
 *             Bypass = AzureNative.Storage.Bypass.AzureServices,
 *             DefaultAction = AzureNative.Storage.DefaultAction.Allow,
 *             IpRules = new() { },
 *             VirtualNetworkRules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.VirtualNetworkRuleArgs
 *                 {
 *                     VirtualNetworkResourceId = "/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Network/virtualNetworks/net123/subnets/subnet12",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "res9101",
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Premium_LRS,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:            pulumi.String("sto4445"),
 * 			EnableHttpsTrafficOnly: pulumi.Bool(false),
 * 			EnableNfsV3:            pulumi.Bool(true),
 * 			IsHnsEnabled:           pulumi.Bool(true),
 * 			Kind:                   pulumi.String(storage.KindBlockBlobStorage),
 * 			Location:               pulumi.String("eastus"),
 * 			NetworkRuleSet: &storage.NetworkRuleSetArgs{
 * 				Bypass:        pulumi.String(storage.BypassAzureServices),
 * 				DefaultAction: storage.DefaultActionAllow,
 * 				IpRules:       storage.IPRuleArray{},
 * 				VirtualNetworkRules: storage.VirtualNetworkRuleArray{
 * 					&storage.VirtualNetworkRuleArgs{
 * 						VirtualNetworkResourceId: pulumi.String("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Network/virtualNetworks/net123/subnets/subnet12"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Premium_LRS),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.NetworkRuleSetArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .enableHttpsTrafficOnly(false)
 *             .enableNfsV3(true)
 *             .isHnsEnabled(true)
 *             .kind("BlockBlobStorage")
 *             .location("eastus")
 *             .networkRuleSet(NetworkRuleSetArgs.builder()
 *                 .bypass("AzureServices")
 *                 .defaultAction("Allow")
 *                 .ipRules()
 *                 .virtualNetworkRules(VirtualNetworkRuleArgs.builder()
 *                     .virtualNetworkResourceId("/subscriptions/{subscription-id}/resourceGroups/res9101/providers/Microsoft.Network/virtualNetworks/net123/subnets/subnet12")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("res9101")
 *             .sku(SkuArgs.builder()
 *                 .name("Premium_LRS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         DefaultToOAuthAuthentication = false,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = AzureNative.Storage.ExtendedLocationTypes.EdgeZone,
 *         },
 *         IsHnsEnabled = true,
 *         IsSftpEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = AzureNative.Storage.RoutingChoice.MicrosoftRouting,
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = AzureNative.Storage.ExpirationAction.Log,
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:                  pulumi.String("sto4445"),
 * 			AllowBlobPublicAccess:        pulumi.Bool(false),
 * 			AllowSharedKeyAccess:         pulumi.Bool(true),
 * 			DefaultToOAuthAuthentication: pulumi.Bool(false),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			ExtendedLocation: &storage.ExtendedLocationArgs{
 * 				Name: pulumi.String("losangeles001"),
 * 				Type: pulumi.String(storage.ExtendedLocationTypesEdgeZone),
 * 			},
 * 			IsHnsEnabled:  pulumi.Bool(true),
 * 			IsSftpEnabled: pulumi.Bool(true),
 * 			KeyPolicy: &storage.KeyPolicyArgs{
 * 				KeyExpirationPeriodInDays: pulumi.Int(20),
 * 			},
 * 			Kind:              pulumi.String(storage.KindStorage),
 * 			Location:          pulumi.String("eastus"),
 * 			MinimumTlsVersion: pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			RoutingPreference: &storage.RoutingPreferenceArgs{
 * 				PublishInternetEndpoints:  pulumi.Bool(true),
 * 				PublishMicrosoftEndpoints: pulumi.Bool(true),
 * 				RoutingChoice:             pulumi.String(storage.RoutingChoiceMicrosoftRouting),
 * 			},
 * 			SasPolicy: &storage.SasPolicyArgs{
 * 				ExpirationAction:    pulumi.String(storage.ExpirationActionLog),
 * 				SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * 			},
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.storage.inputs.KeyPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs;
 * import com.pulumi.azurenative.storage.inputs.SasPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .defaultToOAuthAuthentication(false)
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("losangeles001")
 *                 .type("EdgeZone")
 *                 .build())
 *             .isHnsEnabled(true)
 *             .isSftpEnabled(true)
 *             .keyPolicy(KeyPolicyArgs.builder()
 *                 .keyExpirationPeriodInDays(20)
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .routingPreference(RoutingPreferenceArgs.builder()
 *                 .publishInternetEndpoints(true)
 *                 .publishMicrosoftEndpoints(true)
 *                 .routingChoice("MicrosoftRouting")
 *                 .build())
 *             .sasPolicy(SasPolicyArgs.builder()
 *                 .expirationAction("Log")
 *                 .sasExpirationPeriod("1.15:59:59")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateAllowedCopyScopeToAAD
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         AllowedCopyScope = AzureNative.Storage.AllowedCopyScope.AAD,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         IsHnsEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = AzureNative.Storage.RoutingChoice.MicrosoftRouting,
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = AzureNative.Storage.ExpirationAction.Log,
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:           pulumi.String("sto4445"),
 * 			AllowBlobPublicAccess: pulumi.Bool(false),
 * 			AllowSharedKeyAccess:  pulumi.Bool(true),
 * 			AllowedCopyScope:      pulumi.String(storage.AllowedCopyScopeAAD),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			IsHnsEnabled: pulumi.Bool(true),
 * 			KeyPolicy: &storage.KeyPolicyArgs{
 * 				KeyExpirationPeriodInDays: pulumi.Int(20),
 * 			},
 * 			Kind:              pulumi.String(storage.KindStorage),
 * 			Location:          pulumi.String("eastus"),
 * 			MinimumTlsVersion: pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			RoutingPreference: &storage.RoutingPreferenceArgs{
 * 				PublishInternetEndpoints:  pulumi.Bool(true),
 * 				PublishMicrosoftEndpoints: pulumi.Bool(true),
 * 				RoutingChoice:             pulumi.String(storage.RoutingChoiceMicrosoftRouting),
 * 			},
 * 			SasPolicy: &storage.SasPolicyArgs{
 * 				ExpirationAction:    pulumi.String(storage.ExpirationActionLog),
 * 				SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * 			},
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.KeyPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs;
 * import com.pulumi.azurenative.storage.inputs.SasPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .allowedCopyScope("AAD")
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .isHnsEnabled(true)
 *             .keyPolicy(KeyPolicyArgs.builder()
 *                 .keyExpirationPeriodInDays(20)
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .routingPreference(RoutingPreferenceArgs.builder()
 *                 .publishInternetEndpoints(true)
 *                 .publishMicrosoftEndpoints(true)
 *                 .routingChoice("MicrosoftRouting")
 *                 .build())
 *             .sasPolicy(SasPolicyArgs.builder()
 *                 .expirationAction("Log")
 *                 .sasExpirationPeriod("1.15:59:59")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateAllowedCopyScopeToPrivateLink
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         AllowedCopyScope = AzureNative.Storage.AllowedCopyScope.PrivateLink,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         IsHnsEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = AzureNative.Storage.RoutingChoice.MicrosoftRouting,
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = AzureNative.Storage.ExpirationAction.Log,
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:           pulumi.String("sto4445"),
 * 			AllowBlobPublicAccess: pulumi.Bool(false),
 * 			AllowSharedKeyAccess:  pulumi.Bool(true),
 * 			AllowedCopyScope:      pulumi.String(storage.AllowedCopyScopePrivateLink),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			IsHnsEnabled: pulumi.Bool(true),
 * 			KeyPolicy: &storage.KeyPolicyArgs{
 * 				KeyExpirationPeriodInDays: pulumi.Int(20),
 * 			},
 * 			Kind:              pulumi.String(storage.KindStorage),
 * 			Location:          pulumi.String("eastus"),
 * 			MinimumTlsVersion: pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			RoutingPreference: &storage.RoutingPreferenceArgs{
 * 				PublishInternetEndpoints:  pulumi.Bool(true),
 * 				PublishMicrosoftEndpoints: pulumi.Bool(true),
 * 				RoutingChoice:             pulumi.String(storage.RoutingChoiceMicrosoftRouting),
 * 			},
 * 			SasPolicy: &storage.SasPolicyArgs{
 * 				ExpirationAction:    pulumi.String(storage.ExpirationActionLog),
 * 				SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * 			},
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.KeyPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs;
 * import com.pulumi.azurenative.storage.inputs.SasPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .allowedCopyScope("PrivateLink")
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .isHnsEnabled(true)
 *             .keyPolicy(KeyPolicyArgs.builder()
 *                 .keyExpirationPeriodInDays(20)
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .routingPreference(RoutingPreferenceArgs.builder()
 *                 .publishInternetEndpoints(true)
 *                 .publishMicrosoftEndpoints(true)
 *                 .routingChoice("MicrosoftRouting")
 *                 .build())
 *             .sasPolicy(SasPolicyArgs.builder()
 *                 .expirationAction("Log")
 *                 .sasExpirationPeriod("1.15:59:59")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateDisallowPublicNetworkAccess
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = AzureNative.Storage.ExtendedLocationTypes.EdgeZone,
 *         },
 *         IsHnsEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         PublicNetworkAccess = AzureNative.Storage.PublicNetworkAccess.Disabled,
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = AzureNative.Storage.RoutingChoice.MicrosoftRouting,
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = AzureNative.Storage.ExpirationAction.Log,
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:           pulumi.String("sto4445"),
 * 			AllowBlobPublicAccess: pulumi.Bool(false),
 * 			AllowSharedKeyAccess:  pulumi.Bool(true),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			ExtendedLocation: &storage.ExtendedLocationArgs{
 * 				Name: pulumi.String("losangeles001"),
 * 				Type: pulumi.String(storage.ExtendedLocationTypesEdgeZone),
 * 			},
 * 			IsHnsEnabled: pulumi.Bool(true),
 * 			KeyPolicy: &storage.KeyPolicyArgs{
 * 				KeyExpirationPeriodInDays: pulumi.Int(20),
 * 			},
 * 			Kind:                pulumi.String(storage.KindStorage),
 * 			Location:            pulumi.String("eastus"),
 * 			MinimumTlsVersion:   pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			PublicNetworkAccess: pulumi.String(storage.PublicNetworkAccessDisabled),
 * 			ResourceGroupName:   pulumi.String("res9101"),
 * 			RoutingPreference: &storage.RoutingPreferenceArgs{
 * 				PublishInternetEndpoints:  pulumi.Bool(true),
 * 				PublishMicrosoftEndpoints: pulumi.Bool(true),
 * 				RoutingChoice:             pulumi.String(storage.RoutingChoiceMicrosoftRouting),
 * 			},
 * 			SasPolicy: &storage.SasPolicyArgs{
 * 				ExpirationAction:    pulumi.String(storage.ExpirationActionLog),
 * 				SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * 			},
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.storage.inputs.KeyPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs;
 * import com.pulumi.azurenative.storage.inputs.SasPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("losangeles001")
 *                 .type("EdgeZone")
 *                 .build())
 *             .isHnsEnabled(true)
 *             .keyPolicy(KeyPolicyArgs.builder()
 *                 .keyExpirationPeriodInDays(20)
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .publicNetworkAccess("Disabled")
 *             .resourceGroupName("res9101")
 *             .routingPreference(RoutingPreferenceArgs.builder()
 *                 .publishInternetEndpoints(true)
 *                 .publishMicrosoftEndpoints(true)
 *                 .routingChoice("MicrosoftRouting")
 *                 .build())
 *             .sasPolicy(SasPolicyArgs.builder()
 *                 .expirationAction("Log")
 *                 .sasExpirationPeriod("1.15:59:59")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateDnsEndpointTypeToAzureDnsZone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         DefaultToOAuthAuthentication = false,
 *         DnsEndpointType = AzureNative.Storage.DnsEndpointType.AzureDnsZone,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = AzureNative.Storage.ExtendedLocationTypes.EdgeZone,
 *         },
 *         IsHnsEnabled = true,
 *         IsSftpEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = AzureNative.Storage.RoutingChoice.MicrosoftRouting,
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = AzureNative.Storage.ExpirationAction.Log,
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:                  pulumi.String("sto4445"),
 * 			AllowBlobPublicAccess:        pulumi.Bool(false),
 * 			AllowSharedKeyAccess:         pulumi.Bool(true),
 * 			DefaultToOAuthAuthentication: pulumi.Bool(false),
 * 			DnsEndpointType:              pulumi.String(storage.DnsEndpointTypeAzureDnsZone),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			ExtendedLocation: &storage.ExtendedLocationArgs{
 * 				Name: pulumi.String("losangeles001"),
 * 				Type: pulumi.String(storage.ExtendedLocationTypesEdgeZone),
 * 			},
 * 			IsHnsEnabled:  pulumi.Bool(true),
 * 			IsSftpEnabled: pulumi.Bool(true),
 * 			KeyPolicy: &storage.KeyPolicyArgs{
 * 				KeyExpirationPeriodInDays: pulumi.Int(20),
 * 			},
 * 			Kind:              pulumi.String(storage.KindStorage),
 * 			Location:          pulumi.String("eastus"),
 * 			MinimumTlsVersion: pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			RoutingPreference: &storage.RoutingPreferenceArgs{
 * 				PublishInternetEndpoints:  pulumi.Bool(true),
 * 				PublishMicrosoftEndpoints: pulumi.Bool(true),
 * 				RoutingChoice:             pulumi.String(storage.RoutingChoiceMicrosoftRouting),
 * 			},
 * 			SasPolicy: &storage.SasPolicyArgs{
 * 				ExpirationAction:    pulumi.String(storage.ExpirationActionLog),
 * 				SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * 			},
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.storage.inputs.KeyPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs;
 * import com.pulumi.azurenative.storage.inputs.SasPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .defaultToOAuthAuthentication(false)
 *             .dnsEndpointType("AzureDnsZone")
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("losangeles001")
 *                 .type("EdgeZone")
 *                 .build())
 *             .isHnsEnabled(true)
 *             .isSftpEnabled(true)
 *             .keyPolicy(KeyPolicyArgs.builder()
 *                 .keyExpirationPeriodInDays(20)
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .routingPreference(RoutingPreferenceArgs.builder()
 *                 .publishInternetEndpoints(true)
 *                 .publishMicrosoftEndpoints(true)
 *                 .routingChoice("MicrosoftRouting")
 *                 .build())
 *             .sasPolicy(SasPolicyArgs.builder()
 *                 .expirationAction("Log")
 *                 .sasExpirationPeriod("1.15:59:59")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateDnsEndpointTypeToStandard
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         DefaultToOAuthAuthentication = false,
 *         DnsEndpointType = AzureNative.Storage.DnsEndpointType.Standard,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = AzureNative.Storage.ExtendedLocationTypes.EdgeZone,
 *         },
 *         IsHnsEnabled = true,
 *         IsSftpEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = AzureNative.Storage.RoutingChoice.MicrosoftRouting,
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = AzureNative.Storage.ExpirationAction.Log,
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:                  pulumi.String("sto4445"),
 * 			AllowBlobPublicAccess:        pulumi.Bool(false),
 * 			AllowSharedKeyAccess:         pulumi.Bool(true),
 * 			DefaultToOAuthAuthentication: pulumi.Bool(false),
 * 			DnsEndpointType:              pulumi.String(storage.DnsEndpointTypeStandard),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			ExtendedLocation: &storage.ExtendedLocationArgs{
 * 				Name: pulumi.String("losangeles001"),
 * 				Type: pulumi.String(storage.ExtendedLocationTypesEdgeZone),
 * 			},
 * 			IsHnsEnabled:  pulumi.Bool(true),
 * 			IsSftpEnabled: pulumi.Bool(true),
 * 			KeyPolicy: &storage.KeyPolicyArgs{
 * 				KeyExpirationPeriodInDays: pulumi.Int(20),
 * 			},
 * 			Kind:              pulumi.String(storage.KindStorage),
 * 			Location:          pulumi.String("eastus"),
 * 			MinimumTlsVersion: pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			RoutingPreference: &storage.RoutingPreferenceArgs{
 * 				PublishInternetEndpoints:  pulumi.Bool(true),
 * 				PublishMicrosoftEndpoints: pulumi.Bool(true),
 * 				RoutingChoice:             pulumi.String(storage.RoutingChoiceMicrosoftRouting),
 * 			},
 * 			SasPolicy: &storage.SasPolicyArgs{
 * 				ExpirationAction:    pulumi.String(storage.ExpirationActionLog),
 * 				SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * 			},
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.storage.inputs.KeyPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs;
 * import com.pulumi.azurenative.storage.inputs.SasPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .defaultToOAuthAuthentication(false)
 *             .dnsEndpointType("Standard")
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("losangeles001")
 *                 .type("EdgeZone")
 *                 .build())
 *             .isHnsEnabled(true)
 *             .isSftpEnabled(true)
 *             .keyPolicy(KeyPolicyArgs.builder()
 *                 .keyExpirationPeriodInDays(20)
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .routingPreference(RoutingPreferenceArgs.builder()
 *                 .publishInternetEndpoints(true)
 *                 .publishMicrosoftEndpoints(true)
 *                 .routingChoice("MicrosoftRouting")
 *                 .build())
 *             .sasPolicy(SasPolicyArgs.builder()
 *                 .expirationAction("Log")
 *                 .sasExpirationPeriod("1.15:59:59")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateEnablePublicNetworkAccess
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowBlobPublicAccess = false,
 *         AllowSharedKeyAccess = true,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = AzureNative.Storage.ExtendedLocationTypes.EdgeZone,
 *         },
 *         IsHnsEnabled = true,
 *         KeyPolicy = new AzureNative.Storage.Inputs.KeyPolicyArgs
 *         {
 *             KeyExpirationPeriodInDays = 20,
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         PublicNetworkAccess = AzureNative.Storage.PublicNetworkAccess.Enabled,
 *         ResourceGroupName = "res9101",
 *         RoutingPreference = new AzureNative.Storage.Inputs.RoutingPreferenceArgs
 *         {
 *             PublishInternetEndpoints = true,
 *             PublishMicrosoftEndpoints = true,
 *             RoutingChoice = AzureNative.Storage.RoutingChoice.MicrosoftRouting,
 *         },
 *         SasPolicy = new AzureNative.Storage.Inputs.SasPolicyArgs
 *         {
 *             ExpirationAction = AzureNative.Storage.ExpirationAction.Log,
 *             SasExpirationPeriod = "1.15:59:59",
 *         },
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:           pulumi.String("sto4445"),
 * 			AllowBlobPublicAccess: pulumi.Bool(false),
 * 			AllowSharedKeyAccess:  pulumi.Bool(true),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			ExtendedLocation: &storage.ExtendedLocationArgs{
 * 				Name: pulumi.String("losangeles001"),
 * 				Type: pulumi.String(storage.ExtendedLocationTypesEdgeZone),
 * 			},
 * 			IsHnsEnabled: pulumi.Bool(true),
 * 			KeyPolicy: &storage.KeyPolicyArgs{
 * 				KeyExpirationPeriodInDays: pulumi.Int(20),
 * 			},
 * 			Kind:                pulumi.String(storage.KindStorage),
 * 			Location:            pulumi.String("eastus"),
 * 			MinimumTlsVersion:   pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			PublicNetworkAccess: pulumi.String(storage.PublicNetworkAccessEnabled),
 * 			ResourceGroupName:   pulumi.String("res9101"),
 * 			RoutingPreference: &storage.RoutingPreferenceArgs{
 * 				PublishInternetEndpoints:  pulumi.Bool(true),
 * 				PublishMicrosoftEndpoints: pulumi.Bool(true),
 * 				RoutingChoice:             pulumi.String(storage.RoutingChoiceMicrosoftRouting),
 * 			},
 * 			SasPolicy: &storage.SasPolicyArgs{
 * 				ExpirationAction:    pulumi.String(storage.ExpirationActionLog),
 * 				SasExpirationPeriod: pulumi.String("1.15:59:59"),
 * 			},
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.storage.inputs.KeyPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.RoutingPreferenceArgs;
 * import com.pulumi.azurenative.storage.inputs.SasPolicyArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowBlobPublicAccess(false)
 *             .allowSharedKeyAccess(true)
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("losangeles001")
 *                 .type("EdgeZone")
 *                 .build())
 *             .isHnsEnabled(true)
 *             .keyPolicy(KeyPolicyArgs.builder()
 *                 .keyExpirationPeriodInDays(20)
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("res9101")
 *             .routingPreference(RoutingPreferenceArgs.builder()
 *                 .publishInternetEndpoints(true)
 *                 .publishMicrosoftEndpoints(true)
 *                 .routingChoice("MicrosoftRouting")
 *                 .build())
 *             .sasPolicy(SasPolicyArgs.builder()
 *                 .expirationAction("Log")
 *                 .sasExpirationPeriod("1.15:59:59")
 *                 .build())
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreatePremiumBlockBlobStorage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         AllowSharedKeyAccess = true,
 *         Encryption = new AzureNative.Storage.Inputs.EncryptionArgs
 *         {
 *             KeySource = AzureNative.Storage.KeySource.Microsoft_Storage,
 *             RequireInfrastructureEncryption = false,
 *             Services = new AzureNative.Storage.Inputs.EncryptionServicesArgs
 *             {
 *                 Blob = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *                 File = new AzureNative.Storage.Inputs.EncryptionServiceArgs
 *                 {
 *                     Enabled = true,
 *                     KeyType = AzureNative.Storage.KeyType.Account,
 *                 },
 *             },
 *         },
 *         Kind = AzureNative.Storage.Kind.BlockBlobStorage,
 *         Location = "eastus",
 *         MinimumTlsVersion = AzureNative.Storage.MinimumTlsVersion.TLS1_2,
 *         ResourceGroupName = "res9101",
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Premium_LRS,
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName:          pulumi.String("sto4445"),
 * 			AllowSharedKeyAccess: pulumi.Bool(true),
 * 			Encryption: &storage.EncryptionArgs{
 * 				KeySource:                       pulumi.String(storage.KeySource_Microsoft_Storage),
 * 				RequireInfrastructureEncryption: pulumi.Bool(false),
 * 				Services: &storage.EncryptionServicesArgs{
 * 					Blob: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 					File: &storage.EncryptionServiceArgs{
 * 						Enabled: pulumi.Bool(true),
 * 						KeyType: pulumi.String(storage.KeyTypeAccount),
 * 					},
 * 				},
 * 			},
 * 			Kind:              pulumi.String(storage.KindBlockBlobStorage),
 * 			Location:          pulumi.String("eastus"),
 * 			MinimumTlsVersion: pulumi.String(storage.MinimumTlsVersion_TLS1_2),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Premium_LRS),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs;
 * import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .allowSharedKeyAccess(true)
 *             .encryption(EncryptionArgs.builder()
 *                 .keySource("Microsoft.Storage")
 *                 .requireInfrastructureEncryption(false)
 *                 .services(EncryptionServicesArgs.builder()
 *                     .blob(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .file(EncryptionServiceArgs.builder()
 *                         .enabled(true)
 *                         .keyType("Account")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .kind("BlockBlobStorage")
 *             .location("eastus")
 *             .minimumTlsVersion("TLS1_2")
 *             .resourceGroupName("res9101")
 *             .sku(SkuArgs.builder()
 *                 .name("Premium_LRS")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateWithImmutabilityPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAccount = new AzureNative.Storage.StorageAccount("storageAccount", new()
 *     {
 *         AccountName = "sto4445",
 *         ExtendedLocation = new AzureNative.Storage.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "losangeles001",
 *             Type = AzureNative.Storage.ExtendedLocationTypes.EdgeZone,
 *         },
 *         ImmutableStorageWithVersioning = new AzureNative.Storage.Inputs.ImmutableStorageAccountArgs
 *         {
 *             Enabled = true,
 *             ImmutabilityPolicy = new AzureNative.Storage.Inputs.AccountImmutabilityPolicyPropertiesArgs
 *             {
 *                 AllowProtectedAppendWrites = true,
 *                 ImmutabilityPeriodSinceCreationInDays = 15,
 *                 State = AzureNative.Storage.AccountImmutabilityPolicyState.Unlocked,
 *             },
 *         },
 *         Kind = AzureNative.Storage.Kind.Storage,
 *         Location = "eastus",
 *         ResourceGroupName = "res9101",
 *         Sku = new AzureNative.Storage.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.Storage.SkuName.Standard_GRS,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewStorageAccount(ctx, "storageAccount", &storage.StorageAccountArgs{
 * 			AccountName: pulumi.String("sto4445"),
 * 			ExtendedLocation: &storage.ExtendedLocationArgs{
 * 				Name: pulumi.String("losangeles001"),
 * 				Type: pulumi.String(storage.ExtendedLocationTypesEdgeZone),
 * 			},
 * 			ImmutableStorageWithVersioning: &storage.ImmutableStorageAccountArgs{
 * 				Enabled: pulumi.Bool(true),
 * 				ImmutabilityPolicy: &storage.AccountImmutabilityPolicyPropertiesArgs{
 * 					AllowProtectedAppendWrites:            pulumi.Bool(true),
 * 					ImmutabilityPeriodSinceCreationInDays: pulumi.Int(15),
 * 					State:                                 pulumi.String(storage.AccountImmutabilityPolicyStateUnlocked),
 * 				},
 * 			},
 * 			Kind:              pulumi.String(storage.KindStorage),
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("res9101"),
 * 			Sku: &storage.SkuArgs{
 * 				Name: pulumi.String(storage.SkuName_Standard_GRS),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.StorageAccount;
 * import com.pulumi.azurenative.storage.StorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.ExtendedLocationArgs;
 * import com.pulumi.azurenative.storage.inputs.ImmutableStorageAccountArgs;
 * import com.pulumi.azurenative.storage.inputs.AccountImmutabilityPolicyPropertiesArgs;
 * import com.pulumi.azurenative.storage.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAccount = new StorageAccount("storageAccount", StorageAccountArgs.builder()
 *             .accountName("sto4445")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("losangeles001")
 *                 .type("EdgeZone")
 *                 .build())
 *             .immutableStorageWithVersioning(ImmutableStorageAccountArgs.builder()
 *                 .enabled(true)
 *                 .immutabilityPolicy(AccountImmutabilityPolicyPropertiesArgs.builder()
 *                     .allowProtectedAppendWrites(true)
 *                     .immutabilityPeriodSinceCreationInDays(15)
 *                     .state("Unlocked")
 *                     .build())
 *                 .build())
 *             .kind("Storage")
 *             .location("eastus")
 *             .resourceGroupName("res9101")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard_GRS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:StorageAccount sto4445 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}
 * ```
 */
public class StorageAccount internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.StorageAccount,
) : KotlinCustomResource(javaResource, StorageAccountMapper) {
    /**
     * Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier is the default value for premium block blobs storage account type and it cannot be changed for the premium block blobs storage account type.
     */
    public val accessTier: Output<String>
        get() = javaResource.accessTier().applyValue({ args0 -> args0 })

    /**
     * Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is true for this property.
     */
    public val allowBlobPublicAccess: Output<Boolean>?
        get() = javaResource.allowBlobPublicAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Allow or disallow cross AAD tenant object replication. The default interpretation is true for this property.
     */
    public val allowCrossTenantReplication: Output<Boolean>?
        get() = javaResource.allowCrossTenantReplication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If false, then all requests, including shared access signatures, must be authorized with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
     */
    public val allowSharedKeyAccess: Output<Boolean>?
        get() = javaResource.allowSharedKeyAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
     */
    public val allowedCopyScope: Output<String>?
        get() = javaResource.allowedCopyScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provides the identity based authentication settings for Azure Files.
     */
    public val azureFilesIdentityBasedAuthentication:
        Output<AzureFilesIdentityBasedAuthenticationResponse>?
        get() = javaResource.azureFilesIdentityBasedAuthentication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    azureFilesIdentityBasedAuthenticationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Blob restore status
     */
    public val blobRestoreStatus: Output<BlobRestoreStatusResponse>
        get() = javaResource.blobRestoreStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                blobRestoreStatusResponseToKotlin(args0)
            })
        })

    /**
     * Gets the creation date and time of the storage account in UTC.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * Gets the custom domain the user assigned to this storage account.
     */
    public val customDomain: Output<CustomDomainResponse>
        get() = javaResource.customDomain().applyValue({ args0 ->
            args0.let({ args0 ->
                customDomainResponseToKotlin(args0)
            })
        })

    /**
     * A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false for this property.
     */
    public val defaultToOAuthAuthentication: Output<Boolean>?
        get() = javaResource.defaultToOAuthAuthentication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription, which creates accounts in an Azure DNS Zone and the endpoint URL will have an alphanumeric DNS Zone identifier.
     */
    public val dnsEndpointType: Output<String>?
        get() = javaResource.dnsEndpointType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Allows https traffic only to storage service if sets to true.
     */
    public val enableHttpsTrafficOnly: Output<Boolean>?
        get() = javaResource.enableHttpsTrafficOnly().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * NFS 3.0 protocol support enabled if set to true.
     */
    public val enableNfsV3: Output<Boolean>?
        get() = javaResource.enableNfsV3().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Encryption settings to be used for server-side encryption for the storage account.
     */
    public val encryption: Output<EncryptionResponse>
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.let({ args0 ->
                encryptionResponseToKotlin(args0)
            })
        })

    /**
     * The extendedLocation of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * If the failover is in progress, the value will be true, otherwise, it will be null.
     */
    public val failoverInProgress: Output<Boolean>
        get() = javaResource.failoverInProgress().applyValue({ args0 -> args0 })

    /**
     * Geo Replication Stats
     */
    public val geoReplicationStats: Output<GeoReplicationStatsResponse>
        get() = javaResource.geoReplicationStats().applyValue({ args0 ->
            args0.let({ args0 ->
                geoReplicationStatsResponseToKotlin(args0)
            })
        })

    /**
     * The identity of the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The property is immutable and can only be set to true at the account creation time. When set to true, it enables object level immutability for all the containers in the account by default.
     */
    public val immutableStorageWithVersioning: Output<ImmutableStorageAccountResponse>?
        get() = javaResource.immutableStorageWithVersioning().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> immutableStorageAccountResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Account HierarchicalNamespace enabled if sets to true.
     */
    public val isHnsEnabled: Output<Boolean>?
        get() = javaResource.isHnsEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables local users feature, if set to true
     */
    public val isLocalUserEnabled: Output<Boolean>?
        get() = javaResource.isLocalUserEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enables Secure File Transfer Protocol, if set to true
     */
    public val isSftpEnabled: Output<Boolean>?
        get() = javaResource.isSftpEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Storage account keys creation time.
     */
    public val keyCreationTime: Output<KeyCreationTimeResponse>
        get() = javaResource.keyCreationTime().applyValue({ args0 ->
            args0.let({ args0 ->
                keyCreationTimeResponseToKotlin(args0)
            })
        })

    /**
     * KeyPolicy assigned to the storage account.
     */
    public val keyPolicy: Output<KeyPolicyResponse>
        get() = javaResource.keyPolicy().applyValue({ args0 ->
            args0.let({ args0 ->
                keyPolicyResponseToKotlin(args0)
            })
        })

    /**
     * Gets the Kind.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
     */
    public val largeFileSharesState: Output<String>?
        get() = javaResource.largeFileSharesState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the timestamp of the most recent instance of a failover to the secondary location. Only the most recent timestamp is retained. This element is not returned if there has never been a failover instance. Only available if the accountType is Standard_GRS or Standard_RAGRS.
     */
    public val lastGeoFailoverTime: Output<String>
        get() = javaResource.lastGeoFailoverTime().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
     */
    public val minimumTlsVersion: Output<String>?
        get() = javaResource.minimumTlsVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Network rule set
     */
    public val networkRuleSet: Output<NetworkRuleSetResponse>
        get() = javaResource.networkRuleSet().applyValue({ args0 ->
            args0.let({ args0 ->
                networkRuleSetResponseToKotlin(args0)
            })
        })

    /**
     * Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object. Note that Standard_ZRS and Premium_LRS accounts only return the blob endpoint.
     */
    public val primaryEndpoints: Output<EndpointsResponse>
        get() = javaResource.primaryEndpoints().applyValue({ args0 ->
            args0.let({ args0 ->
                endpointsResponseToKotlin(args0)
            })
        })

    /**
     * Gets the location of the primary data center for the storage account.
     */
    public val primaryLocation: Output<String>
        get() = javaResource.primaryLocation().applyValue({ args0 -> args0 })

    /**
     * List of private endpoint connection associated with the specified storage account
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointConnectionResponseToKotlin(args0) })
            })
        })

    /**
     * Gets the status of the storage account at the time the operation was called.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maintains information about the network routing choice opted by the user for data transfer
     */
    public val routingPreference: Output<RoutingPreferenceResponse>?
        get() = javaResource.routingPreference().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> routingPreferenceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * SasPolicy assigned to the storage account.
     */
    public val sasPolicy: Output<SasPolicyResponse>
        get() = javaResource.sasPolicy().applyValue({ args0 ->
            args0.let({ args0 ->
                sasPolicyResponseToKotlin(args0)
            })
        })

    /**
     * Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object from the secondary location of the storage account. Only available if the SKU name is Standard_RAGRS.
     */
    public val secondaryEndpoints: Output<EndpointsResponse>
        get() = javaResource.secondaryEndpoints().applyValue({ args0 ->
            args0.let({ args0 ->
                endpointsResponseToKotlin(args0)
            })
        })

    /**
     * Gets the location of the geo-replicated secondary for the storage account. Only available if the accountType is Standard_GRS or Standard_RAGRS.
     */
    public val secondaryLocation: Output<String>
        get() = javaResource.secondaryLocation().applyValue({ args0 -> args0 })

    /**
     * Gets the SKU.
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * Gets the status indicating whether the primary location of the storage account is available or unavailable.
     */
    public val statusOfPrimary: Output<String>
        get() = javaResource.statusOfPrimary().applyValue({ args0 -> args0 })

    /**
     * Gets the status indicating whether the secondary location of the storage account is available or unavailable. Only available if the SKU name is Standard_GRS or Standard_RAGRS.
     */
    public val statusOfSecondary: Output<String>
        get() = javaResource.statusOfSecondary().applyValue({ args0 -> args0 })

    /**
     * This property is readOnly and is set by server during asynchronous storage account sku conversion operations.
     */
    public val storageAccountSkuConversionStatus: Output<StorageAccountSkuConversionStatusResponse>?
        get() = javaResource.storageAccountSkuConversionStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    storageAccountSkuConversionStatusResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StorageAccountMapper : ResourceMapper<StorageAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.StorageAccount::class == javaResource::class

    override fun map(javaResource: Resource): StorageAccount = StorageAccount(
        javaResource as
            com.pulumi.azurenative.storage.StorageAccount,
    )
}

/**
 * @see [StorageAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageAccount].
 */
public suspend fun storageAccount(
    name: String,
    block: suspend StorageAccountResourceBuilder.() -> Unit,
): StorageAccount {
    val builder = StorageAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageAccount(name: String): StorageAccount {
    val builder = StorageAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
