@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StorageAccountStaticWebsite].
 */
@PulumiTagMarker
public class StorageAccountStaticWebsiteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageAccountStaticWebsiteArgs = StorageAccountStaticWebsiteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageAccountStaticWebsiteArgsBuilder.() -> Unit) {
        val builder = StorageAccountStaticWebsiteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StorageAccountStaticWebsite {
        val builtJavaResource =
            com.pulumi.azurenative.storage.StorageAccountStaticWebsite(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StorageAccountStaticWebsite(builtJavaResource)
    }
}

/**
 * Enables the static website feature of a storage account.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:StorageAccountStaticWebsite myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/staticWebsite
 * ```
 */
public class StorageAccountStaticWebsite internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.StorageAccountStaticWebsite,
) : KotlinCustomResource(javaResource, StorageAccountStaticWebsiteMapper) {
    /**
     * The name of the container to upload blobs to.
     */
    public val containerName: Output<String>
        get() = javaResource.containerName().applyValue({ args0 -> args0 })

    /**
     * The absolute path to a custom webpage that should be used when a request is made which does not correspond to an existing file.
     */
    public val error404Document: Output<String>?
        get() = javaResource.error404Document().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The webpage that Azure Storage serves for requests to the root of a website or any sub-folder. For example, 'index.html'. The value is case-sensitive.
     */
    public val indexDocument: Output<String>?
        get() = javaResource.indexDocument().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object StorageAccountStaticWebsiteMapper : ResourceMapper<StorageAccountStaticWebsite> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.StorageAccountStaticWebsite::class == javaResource::class

    override fun map(javaResource: Resource): StorageAccountStaticWebsite =
        StorageAccountStaticWebsite(
            javaResource as
                com.pulumi.azurenative.storage.StorageAccountStaticWebsite,
        )
}

/**
 * @see [StorageAccountStaticWebsite].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageAccountStaticWebsite].
 */
public suspend fun storageAccountStaticWebsite(
    name: String,
    block: suspend StorageAccountStaticWebsiteResourceBuilder.() -> Unit,
):
    StorageAccountStaticWebsite {
    val builder = StorageAccountStaticWebsiteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageAccountStaticWebsite].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageAccountStaticWebsite(name: String): StorageAccountStaticWebsite {
    val builder = StorageAccountStaticWebsiteResourceBuilder()
    builder.name(name)
    return builder.build()
}
