@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.TableArgs.builder
import com.pulumi.azurenative.storage.kotlin.inputs.TableSignedIdentifierArgs
import com.pulumi.azurenative.storage.kotlin.inputs.TableSignedIdentifierArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of the table, including Id, resource name, resource type.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01, 2023-04-01.
 * ## Example Usage
 * ### TableOperationPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var table = new AzureNative.Storage.Table("table", new()
 *     {
 *         AccountName = "sto328",
 *         ResourceGroupName = "res3376",
 *         TableName = "table6185",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewTable(ctx, "table", &storage.TableArgs{
 * 			AccountName:       pulumi.String("sto328"),
 * 			ResourceGroupName: pulumi.String("res3376"),
 * 			TableName:         pulumi.String("table6185"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.Table;
 * import com.pulumi.azurenative.storage.TableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var table = new Table("table", TableArgs.builder()
 *             .accountName("sto328")
 *             .resourceGroupName("res3376")
 *             .tableName("table6185")
 *             .build());
 *     }
 * }
 * ```
 * ### TableOperationPutOrPatchAcls
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var table = new AzureNative.Storage.Table("table", new()
 *     {
 *         AccountName = "sto328",
 *         ResourceGroupName = "res3376",
 *         SignedIdentifiers = new[]
 *         {
 *             new AzureNative.Storage.Inputs.TableSignedIdentifierArgs
 *             {
 *                 AccessPolicy = new AzureNative.Storage.Inputs.TableAccessPolicyArgs
 *                 {
 *                     ExpiryTime = "2022-03-20T08:49:37.0000000Z",
 *                     Permission = "raud",
 *                     StartTime = "2022-03-17T08:49:37.0000000Z",
 *                 },
 *                 Id = "MTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTI",
 *             },
 *             new AzureNative.Storage.Inputs.TableSignedIdentifierArgs
 *             {
 *                 AccessPolicy = new AzureNative.Storage.Inputs.TableAccessPolicyArgs
 *                 {
 *                     ExpiryTime = "2022-03-20T08:49:37.0000000Z",
 *                     Permission = "rad",
 *                     StartTime = "2022-03-17T08:49:37.0000000Z",
 *                 },
 *                 Id = "PTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODklMTI",
 *             },
 *         },
 *         TableName = "table6185",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewTable(ctx, "table", &storage.TableArgs{
 * 			AccountName:       pulumi.String("sto328"),
 * 			ResourceGroupName: pulumi.String("res3376"),
 * 			SignedIdentifiers: storage.TableSignedIdentifierArray{
 * 				&storage.TableSignedIdentifierArgs{
 * 					AccessPolicy: &storage.TableAccessPolicyArgs{
 * 						ExpiryTime: pulumi.String("2022-03-20T08:49:37.0000000Z"),
 * 						Permission: pulumi.String("raud"),
 * 						StartTime:  pulumi.String("2022-03-17T08:49:37.0000000Z"),
 * 					},
 * 					Id: pulumi.String("MTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTI"),
 * 				},
 * 				&storage.TableSignedIdentifierArgs{
 * 					AccessPolicy: &storage.TableAccessPolicyArgs{
 * 						ExpiryTime: pulumi.String("2022-03-20T08:49:37.0000000Z"),
 * 						Permission: pulumi.String("rad"),
 * 						StartTime:  pulumi.String("2022-03-17T08:49:37.0000000Z"),
 * 					},
 * 					Id: pulumi.String("PTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODklMTI"),
 * 				},
 * 			},
 * 			TableName: pulumi.String("table6185"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.Table;
 * import com.pulumi.azurenative.storage.TableArgs;
 * import com.pulumi.azurenative.storage.inputs.TableSignedIdentifierArgs;
 * import com.pulumi.azurenative.storage.inputs.TableAccessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var table = new Table("table", TableArgs.builder()
 *             .accountName("sto328")
 *             .resourceGroupName("res3376")
 *             .signedIdentifiers(
 *                 TableSignedIdentifierArgs.builder()
 *                     .accessPolicy(TableAccessPolicyArgs.builder()
 *                         .expiryTime("2022-03-20T08:49:37.0000000Z")
 *                         .permission("raud")
 *                         .startTime("2022-03-17T08:49:37.0000000Z")
 *                         .build())
 *                     .id("MTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTI")
 *                     .build(),
 *                 TableSignedIdentifierArgs.builder()
 *                     .accessPolicy(TableAccessPolicyArgs.builder()
 *                         .expiryTime("2022-03-20T08:49:37.0000000Z")
 *                         .permission("rad")
 *                         .startTime("2022-03-17T08:49:37.0000000Z")
 *                         .build())
 *                     .id("PTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODklMTI")
 *                     .build())
 *             .tableName("table6185")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:Table table6185 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/tableServices/default/tables/{tableName}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property signedIdentifiers List of stored access policies specified on the table.
 * @property tableName A table name must be unique within a storage account and must be between 3 and 63 characters.The name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
 */
public data class TableArgs(
    public val accountName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val signedIdentifiers: Output<List<TableSignedIdentifierArgs>>? = null,
    public val tableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.TableArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.TableArgs =
        com.pulumi.azurenative.storage.TableArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .signedIdentifiers(
                signedIdentifiers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableArgs].
 */
@PulumiTagMarker
public class TableArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var signedIdentifiers: Output<List<TableSignedIdentifierArgs>>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("yrmaumqubhnoibay")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("edundkwhrgcvlfhf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value List of stored access policies specified on the table.
     */
    @JvmName("mwnltdsanfautgtc")
    public suspend fun signedIdentifiers(`value`: Output<List<TableSignedIdentifierArgs>>) {
        this.signedIdentifiers = value
    }

    @JvmName("yaqqgsrptbmwdycm")
    public suspend fun signedIdentifiers(vararg values: Output<TableSignedIdentifierArgs>) {
        this.signedIdentifiers = Output.all(values.asList())
    }

    /**
     * @param values List of stored access policies specified on the table.
     */
    @JvmName("irctjvoipowrvaxv")
    public suspend fun signedIdentifiers(values: List<Output<TableSignedIdentifierArgs>>) {
        this.signedIdentifiers = Output.all(values)
    }

    /**
     * @param value A table name must be unique within a storage account and must be between 3 and 63 characters.The name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     */
    @JvmName("coctxgqwxrgscnon")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("asjcuxjdrsutwwyb")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("pqoucpidcgspxwmy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value List of stored access policies specified on the table.
     */
    @JvmName("tdhyeveswfoxtafs")
    public suspend fun signedIdentifiers(`value`: List<TableSignedIdentifierArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signedIdentifiers = mapped
    }

    /**
     * @param argument List of stored access policies specified on the table.
     */
    @JvmName("yfcyrxujfioevrrx")
    public suspend
    fun signedIdentifiers(argument: List<suspend TableSignedIdentifierArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TableSignedIdentifierArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.signedIdentifiers = mapped
    }

    /**
     * @param argument List of stored access policies specified on the table.
     */
    @JvmName("iqjnpsdwxqpxevnf")
    public suspend fun signedIdentifiers(
        vararg
        argument: suspend TableSignedIdentifierArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            TableSignedIdentifierArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.signedIdentifiers = mapped
    }

    /**
     * @param argument List of stored access policies specified on the table.
     */
    @JvmName("lsihkqkcxnytuxvd")
    public suspend
    fun signedIdentifiers(argument: suspend TableSignedIdentifierArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TableSignedIdentifierArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.signedIdentifiers = mapped
    }

    /**
     * @param values List of stored access policies specified on the table.
     */
    @JvmName("ntycsgtiskdesxqd")
    public suspend fun signedIdentifiers(vararg values: TableSignedIdentifierArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.signedIdentifiers = mapped
    }

    /**
     * @param value A table name must be unique within a storage account and must be between 3 and 63 characters.The name must comprise of only alphanumeric characters and it cannot begin with a numeric character.
     */
    @JvmName("crdceppibnkrwkvx")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): TableArgs = TableArgs(
        accountName = accountName,
        resourceGroupName = resourceGroupName,
        signedIdentifiers = signedIdentifiers,
        tableName = tableName,
    )
}
