@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t), File (f).
 */
public enum class Services(
    public val javaValue: com.pulumi.azurenative.storage.enums.Services,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.Services> {
    B(com.pulumi.azurenative.storage.enums.Services.B),
    Q(com.pulumi.azurenative.storage.enums.Services.Q),
    T(com.pulumi.azurenative.storage.enums.Services.T),
    F(com.pulumi.azurenative.storage.enums.Services.F),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.Services = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.Services): Services =
            Services.values().first { it.javaValue == javaType }
    }
}
