@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.BlobInventoryPolicyRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * An object that wraps the blob inventory rule. Each rule is uniquely defined by name.
 * @property definition An object that defines the blob inventory policy rule.
 * @property destination Container name where blob inventory files are stored. Must be pre-created.
 * @property enabled Rule is enabled when set to true.
 * @property name A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
 */
public data class BlobInventoryPolicyRuleArgs(
    public val definition: Output<BlobInventoryPolicyDefinitionArgs>,
    public val destination: Output<String>,
    public val enabled: Output<Boolean>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.BlobInventoryPolicyRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.BlobInventoryPolicyRuleArgs =
        com.pulumi.azurenative.storage.inputs.BlobInventoryPolicyRuleArgs.builder()
            .definition(definition.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .destination(destination.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobInventoryPolicyRuleArgs].
 */
@PulumiTagMarker
public class BlobInventoryPolicyRuleArgsBuilder internal constructor() {
    private var definition: Output<BlobInventoryPolicyDefinitionArgs>? = null

    private var destination: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    /**
     * @param value An object that defines the blob inventory policy rule.
     */
    @JvmName("vbhjatyhedrbrhcc")
    public suspend fun definition(`value`: Output<BlobInventoryPolicyDefinitionArgs>) {
        this.definition = value
    }

    /**
     * @param value Container name where blob inventory files are stored. Must be pre-created.
     */
    @JvmName("tdiifgbigrmjyffs")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value Rule is enabled when set to true.
     */
    @JvmName("vdlgpsthbsgkdqej")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
     */
    @JvmName("fscijmyvsygiuyei")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An object that defines the blob inventory policy rule.
     */
    @JvmName("ckvqtrxiedhtgyrp")
    public suspend fun definition(`value`: BlobInventoryPolicyDefinitionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param argument An object that defines the blob inventory policy rule.
     */
    @JvmName("resxvnnnfinpedmr")
    public suspend
    fun definition(argument: suspend BlobInventoryPolicyDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = BlobInventoryPolicyDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.definition = mapped
    }

    /**
     * @param value Container name where blob inventory files are stored. Must be pre-created.
     */
    @JvmName("hmuqmdjhjnudnwyr")
    public suspend fun destination(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value Rule is enabled when set to true.
     */
    @JvmName("piurqsaldriqkxix")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
     */
    @JvmName("ubvhktqvqqtmiswn")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): BlobInventoryPolicyRuleArgs = BlobInventoryPolicyRuleArgs(
        definition = definition ?: throw PulumiNullFieldException("definition"),
        destination = destination ?: throw PulumiNullFieldException("destination"),
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
