@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.GetBlobContainerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property containerName The name of the blob container within the specified storage account. Blob container names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetBlobContainerPlainArgs(
    public val accountName: String,
    public val containerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.GetBlobContainerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.GetBlobContainerPlainArgs =
        com.pulumi.azurenative.storage.inputs.GetBlobContainerPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .containerName(containerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBlobContainerPlainArgs].
 */
@PulumiTagMarker
public class GetBlobContainerPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var containerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("sttsjqhdleuinbye")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the blob container within the specified storage account. Blob container names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     */
    @JvmName("ihhafrshuylnirxi")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("lshjsfrqdqmocpac")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBlobContainerPlainArgs = GetBlobContainerPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
