@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.GetFileServicePropertiesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property fileServicesName The name of the file Service within the specified storage account. File Service Name must be "default"
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetFileServicePropertiesPlainArgs(
    public val accountName: String,
    public val fileServicesName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.GetFileServicePropertiesPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.GetFileServicePropertiesPlainArgs =
        com.pulumi.azurenative.storage.inputs.GetFileServicePropertiesPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .fileServicesName(fileServicesName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFileServicePropertiesPlainArgs].
 */
@PulumiTagMarker
public class GetFileServicePropertiesPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var fileServicesName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("moleyuifpaihyjub")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the file Service within the specified storage account. File Service Name must be "default"
     */
    @JvmName("upjedkskdxemxhvo")
    public suspend fun fileServicesName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fileServicesName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("ijjwcwmkqcnmagxr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFileServicePropertiesPlainArgs = GetFileServicePropertiesPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        fileServicesName = fileServicesName ?: throw PulumiNullFieldException("fileServicesName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
