@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.GetManagementPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property managementPolicyName The name of the Storage Account Management Policy. It should always be 'default'
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetManagementPolicyPlainArgs(
    public val accountName: String,
    public val managementPolicyName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.GetManagementPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.GetManagementPolicyPlainArgs =
        com.pulumi.azurenative.storage.inputs.GetManagementPolicyPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .managementPolicyName(managementPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagementPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetManagementPolicyPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var managementPolicyName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("qgegbonpkqoqavlj")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the Storage Account Management Policy. It should always be 'default'
     */
    @JvmName("btkltqiukmtygxwt")
    public suspend fun managementPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementPolicyName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("fdhirkxlfckbmsqf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagementPolicyPlainArgs = GetManagementPolicyPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        managementPolicyName = managementPolicyName ?: throw
            PulumiNullFieldException("managementPolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
