@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.KeyPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * KeyPolicy assigned to the storage account.
 * @property keyExpirationPeriodInDays The key expiration period in days.
 */
public data class KeyPolicyArgs(
    public val keyExpirationPeriodInDays: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.KeyPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.KeyPolicyArgs =
        com.pulumi.azurenative.storage.inputs.KeyPolicyArgs.builder()
            .keyExpirationPeriodInDays(keyExpirationPeriodInDays.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyPolicyArgs].
 */
@PulumiTagMarker
public class KeyPolicyArgsBuilder internal constructor() {
    private var keyExpirationPeriodInDays: Output<Int>? = null

    /**
     * @param value The key expiration period in days.
     */
    @JvmName("kcnsghhlfypljqxm")
    public suspend fun keyExpirationPeriodInDays(`value`: Output<Int>) {
        this.keyExpirationPeriodInDays = value
    }

    /**
     * @param value The key expiration period in days.
     */
    @JvmName("nppovncqphbucayp")
    public suspend fun keyExpirationPeriodInDays(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyExpirationPeriodInDays = mapped
    }

    internal fun build(): KeyPolicyArgs = KeyPolicyArgs(
        keyExpirationPeriodInDays = keyExpirationPeriodInDays ?: throw
            PulumiNullFieldException("keyExpirationPeriodInDays"),
    )
}
