@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.LastAccessTimeTrackingPolicyArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.Name
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The blob service properties for Last access time based tracking policy.
 * @property blobType An array of predefined supported blob types. Only blockBlob is the supported value. This field is currently read only
 * @property enable When set to true last access time based tracking is enabled.
 * @property name Name of the policy. The valid value is AccessTimeTracking. This field is currently read only
 * @property trackingGranularityInDays The field specifies blob object tracking granularity in days, typically how often the blob object should be tracked.This field is currently read only with value as 1
 */
public data class LastAccessTimeTrackingPolicyArgs(
    public val blobType: Output<List<String>>? = null,
    public val enable: Output<Boolean>,
    public val name: Output<Either<String, Name>>? = null,
    public val trackingGranularityInDays: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.LastAccessTimeTrackingPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.LastAccessTimeTrackingPolicyArgs =
        com.pulumi.azurenative.storage.inputs.LastAccessTimeTrackingPolicyArgs.builder()
            .blobType(blobType?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enable(enable.applyValue({ args0 -> args0 }))
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .trackingGranularityInDays(trackingGranularityInDays?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LastAccessTimeTrackingPolicyArgs].
 */
@PulumiTagMarker
public class LastAccessTimeTrackingPolicyArgsBuilder internal constructor() {
    private var blobType: Output<List<String>>? = null

    private var enable: Output<Boolean>? = null

    private var name: Output<Either<String, Name>>? = null

    private var trackingGranularityInDays: Output<Int>? = null

    /**
     * @param value An array of predefined supported blob types. Only blockBlob is the supported value. This field is currently read only
     */
    @JvmName("imodfudwdimfmdkl")
    public suspend fun blobType(`value`: Output<List<String>>) {
        this.blobType = value
    }

    @JvmName("fjuuobmcwkraqvuv")
    public suspend fun blobType(vararg values: Output<String>) {
        this.blobType = Output.all(values.asList())
    }

    /**
     * @param values An array of predefined supported blob types. Only blockBlob is the supported value. This field is currently read only
     */
    @JvmName("xhuwwxoaniqynmok")
    public suspend fun blobType(values: List<Output<String>>) {
        this.blobType = Output.all(values)
    }

    /**
     * @param value When set to true last access time based tracking is enabled.
     */
    @JvmName("nrttbaoogvseelkr")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Name of the policy. The valid value is AccessTimeTracking. This field is currently read only
     */
    @JvmName("xswuykxxbayqmdem")
    public suspend fun name(`value`: Output<Either<String, Name>>) {
        this.name = value
    }

    /**
     * @param value The field specifies blob object tracking granularity in days, typically how often the blob object should be tracked.This field is currently read only with value as 1
     */
    @JvmName("xdtphqrhigpdatty")
    public suspend fun trackingGranularityInDays(`value`: Output<Int>) {
        this.trackingGranularityInDays = value
    }

    /**
     * @param value An array of predefined supported blob types. Only blockBlob is the supported value. This field is currently read only
     */
    @JvmName("nqenawiqnfdtevkx")
    public suspend fun blobType(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobType = mapped
    }

    /**
     * @param values An array of predefined supported blob types. Only blockBlob is the supported value. This field is currently read only
     */
    @JvmName("fqhueljwvqprnypb")
    public suspend fun blobType(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobType = mapped
    }

    /**
     * @param value When set to true last access time based tracking is enabled.
     */
    @JvmName("xjugtntukttyomka")
    public suspend fun enable(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Name of the policy. The valid value is AccessTimeTracking. This field is currently read only
     */
    @JvmName("urihayjiydvcmpet")
    public suspend fun name(`value`: Either<String, Name>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the policy. The valid value is AccessTimeTracking. This field is currently read only
     */
    @JvmName("bwirgxxmhcgjognn")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Name>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the policy. The valid value is AccessTimeTracking. This field is currently read only
     */
    @JvmName("bjvumhxicuvjjbtu")
    public fun name(`value`: Name) {
        val toBeMapped = Either.ofRight<String, Name>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The field specifies blob object tracking granularity in days, typically how often the blob object should be tracked.This field is currently read only with value as 1
     */
    @JvmName("oovnkictvpmmgrpt")
    public suspend fun trackingGranularityInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trackingGranularityInDays = mapped
    }

    internal fun build(): LastAccessTimeTrackingPolicyArgs = LastAccessTimeTrackingPolicyArgs(
        blobType = blobType,
        enable = enable ?: throw PulumiNullFieldException("enable"),
        name = name,
        trackingGranularityInDays = trackingGranularityInDays,
    )
}
