@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ManagementPolicyFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Filters limit rule actions to a subset of blobs within the storage account. If multiple filters are defined, a logical AND is performed on all filters.
 * @property blobIndexMatch An array of blob index tag based filters, there can be at most 10 tag filters
 * @property blobTypes An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
 * @property prefixMatch An array of strings for prefixes to be match.
 */
public data class ManagementPolicyFilterArgs(
    public val blobIndexMatch: Output<List<TagFilterArgs>>? = null,
    public val blobTypes: Output<List<String>>,
    public val prefixMatch: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ManagementPolicyFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ManagementPolicyFilterArgs =
        com.pulumi.azurenative.storage.inputs.ManagementPolicyFilterArgs.builder()
            .blobIndexMatch(
                blobIndexMatch?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .blobTypes(blobTypes.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .prefixMatch(prefixMatch?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ManagementPolicyFilterArgs].
 */
@PulumiTagMarker
public class ManagementPolicyFilterArgsBuilder internal constructor() {
    private var blobIndexMatch: Output<List<TagFilterArgs>>? = null

    private var blobTypes: Output<List<String>>? = null

    private var prefixMatch: Output<List<String>>? = null

    /**
     * @param value An array of blob index tag based filters, there can be at most 10 tag filters
     */
    @JvmName("fdnajfusqdpsjvbx")
    public suspend fun blobIndexMatch(`value`: Output<List<TagFilterArgs>>) {
        this.blobIndexMatch = value
    }

    @JvmName("keqsjkbjumvvgcja")
    public suspend fun blobIndexMatch(vararg values: Output<TagFilterArgs>) {
        this.blobIndexMatch = Output.all(values.asList())
    }

    /**
     * @param values An array of blob index tag based filters, there can be at most 10 tag filters
     */
    @JvmName("btnirpynybyahibk")
    public suspend fun blobIndexMatch(values: List<Output<TagFilterArgs>>) {
        this.blobIndexMatch = Output.all(values)
    }

    /**
     * @param value An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
     */
    @JvmName("qkpkmochvqtyhoyx")
    public suspend fun blobTypes(`value`: Output<List<String>>) {
        this.blobTypes = value
    }

    @JvmName("xvlipsnyphlxcgdw")
    public suspend fun blobTypes(vararg values: Output<String>) {
        this.blobTypes = Output.all(values.asList())
    }

    /**
     * @param values An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
     */
    @JvmName("pomcharosmnvegjt")
    public suspend fun blobTypes(values: List<Output<String>>) {
        this.blobTypes = Output.all(values)
    }

    /**
     * @param value An array of strings for prefixes to be match.
     */
    @JvmName("lkdhhptedqthcfsm")
    public suspend fun prefixMatch(`value`: Output<List<String>>) {
        this.prefixMatch = value
    }

    @JvmName("btsyulmjmlkcygyd")
    public suspend fun prefixMatch(vararg values: Output<String>) {
        this.prefixMatch = Output.all(values.asList())
    }

    /**
     * @param values An array of strings for prefixes to be match.
     */
    @JvmName("spgfohigqtciouqd")
    public suspend fun prefixMatch(values: List<Output<String>>) {
        this.prefixMatch = Output.all(values)
    }

    /**
     * @param value An array of blob index tag based filters, there can be at most 10 tag filters
     */
    @JvmName("nswjfpptbxygytfd")
    public suspend fun blobIndexMatch(`value`: List<TagFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobIndexMatch = mapped
    }

    /**
     * @param argument An array of blob index tag based filters, there can be at most 10 tag filters
     */
    @JvmName("ccbndcjufycxmefg")
    public suspend fun blobIndexMatch(argument: List<suspend TagFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { TagFilterArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.blobIndexMatch = mapped
    }

    /**
     * @param argument An array of blob index tag based filters, there can be at most 10 tag filters
     */
    @JvmName("qsqtyrrigxthmodm")
    public suspend fun blobIndexMatch(vararg argument: suspend TagFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { TagFilterArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.blobIndexMatch = mapped
    }

    /**
     * @param argument An array of blob index tag based filters, there can be at most 10 tag filters
     */
    @JvmName("wwpxmylufaribsev")
    public suspend fun blobIndexMatch(argument: suspend TagFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TagFilterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.blobIndexMatch = mapped
    }

    /**
     * @param values An array of blob index tag based filters, there can be at most 10 tag filters
     */
    @JvmName("nlqgyoabwufaknnb")
    public suspend fun blobIndexMatch(vararg values: TagFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobIndexMatch = mapped
    }

    /**
     * @param value An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
     */
    @JvmName("kkdnqpvanpbegjjv")
    public suspend fun blobTypes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobTypes = mapped
    }

    /**
     * @param values An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob.
     */
    @JvmName("swdrqxyvoyvnmuek")
    public suspend fun blobTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobTypes = mapped
    }

    /**
     * @param value An array of strings for prefixes to be match.
     */
    @JvmName("crvivxbitynepdrt")
    public suspend fun prefixMatch(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixMatch = mapped
    }

    /**
     * @param values An array of strings for prefixes to be match.
     */
    @JvmName("oaliaqivanwfgvch")
    public suspend fun prefixMatch(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixMatch = mapped
    }

    internal fun build(): ManagementPolicyFilterArgs = ManagementPolicyFilterArgs(
        blobIndexMatch = blobIndexMatch,
        blobTypes = blobTypes ?: throw PulumiNullFieldException("blobTypes"),
        prefixMatch = prefixMatch,
    )
}
