@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ManagementPolicySnapShotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Management policy action for snapshot.
 * @property delete The function to delete the blob snapshot
 * @property tierToArchive The function to tier blob snapshot to archive storage.
 * @property tierToCold The function to tier blobs to cold storage.
 * @property tierToCool The function to tier blob snapshot to cool storage.
 * @property tierToHot The function to tier blobs to hot storage. This action can only be used with Premium Block Blob Storage Accounts
 */
public data class ManagementPolicySnapShotArgs(
    public val delete: Output<DateAfterCreationArgs>? = null,
    public val tierToArchive: Output<DateAfterCreationArgs>? = null,
    public val tierToCold: Output<DateAfterCreationArgs>? = null,
    public val tierToCool: Output<DateAfterCreationArgs>? = null,
    public val tierToHot: Output<DateAfterCreationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ManagementPolicySnapShotArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ManagementPolicySnapShotArgs =
        com.pulumi.azurenative.storage.inputs.ManagementPolicySnapShotArgs.builder()
            .delete(delete?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tierToArchive(tierToArchive?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tierToCold(tierToCold?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tierToCool(tierToCool?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tierToHot(tierToHot?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ManagementPolicySnapShotArgs].
 */
@PulumiTagMarker
public class ManagementPolicySnapShotArgsBuilder internal constructor() {
    private var delete: Output<DateAfterCreationArgs>? = null

    private var tierToArchive: Output<DateAfterCreationArgs>? = null

    private var tierToCold: Output<DateAfterCreationArgs>? = null

    private var tierToCool: Output<DateAfterCreationArgs>? = null

    private var tierToHot: Output<DateAfterCreationArgs>? = null

    /**
     * @param value The function to delete the blob snapshot
     */
    @JvmName("gjjijgrecqrvhveu")
    public suspend fun delete(`value`: Output<DateAfterCreationArgs>) {
        this.delete = value
    }

    /**
     * @param value The function to tier blob snapshot to archive storage.
     */
    @JvmName("vrqjobxgsbchemyd")
    public suspend fun tierToArchive(`value`: Output<DateAfterCreationArgs>) {
        this.tierToArchive = value
    }

    /**
     * @param value The function to tier blobs to cold storage.
     */
    @JvmName("lgfaauijpeitqgxy")
    public suspend fun tierToCold(`value`: Output<DateAfterCreationArgs>) {
        this.tierToCold = value
    }

    /**
     * @param value The function to tier blob snapshot to cool storage.
     */
    @JvmName("aobqgpbyliayfnqi")
    public suspend fun tierToCool(`value`: Output<DateAfterCreationArgs>) {
        this.tierToCool = value
    }

    /**
     * @param value The function to tier blobs to hot storage. This action can only be used with Premium Block Blob Storage Accounts
     */
    @JvmName("nvskhrnhhtendtni")
    public suspend fun tierToHot(`value`: Output<DateAfterCreationArgs>) {
        this.tierToHot = value
    }

    /**
     * @param value The function to delete the blob snapshot
     */
    @JvmName("pbhfmnkhwlpkgpcd")
    public suspend fun delete(`value`: DateAfterCreationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delete = mapped
    }

    /**
     * @param argument The function to delete the blob snapshot
     */
    @JvmName("qbglountweptuscd")
    public suspend fun delete(argument: suspend DateAfterCreationArgsBuilder.() -> Unit) {
        val toBeMapped = DateAfterCreationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.delete = mapped
    }

    /**
     * @param value The function to tier blob snapshot to archive storage.
     */
    @JvmName("lgpixwkolradesgl")
    public suspend fun tierToArchive(`value`: DateAfterCreationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tierToArchive = mapped
    }

    /**
     * @param argument The function to tier blob snapshot to archive storage.
     */
    @JvmName("kvcnkepjsghdgajv")
    public suspend fun tierToArchive(argument: suspend DateAfterCreationArgsBuilder.() -> Unit) {
        val toBeMapped = DateAfterCreationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tierToArchive = mapped
    }

    /**
     * @param value The function to tier blobs to cold storage.
     */
    @JvmName("kmbijcwrxoarfrqi")
    public suspend fun tierToCold(`value`: DateAfterCreationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tierToCold = mapped
    }

    /**
     * @param argument The function to tier blobs to cold storage.
     */
    @JvmName("sdsqnkjhxxgsgjrg")
    public suspend fun tierToCold(argument: suspend DateAfterCreationArgsBuilder.() -> Unit) {
        val toBeMapped = DateAfterCreationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tierToCold = mapped
    }

    /**
     * @param value The function to tier blob snapshot to cool storage.
     */
    @JvmName("vedakqdqdwuullqy")
    public suspend fun tierToCool(`value`: DateAfterCreationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tierToCool = mapped
    }

    /**
     * @param argument The function to tier blob snapshot to cool storage.
     */
    @JvmName("jfjvvvndxhgbvulv")
    public suspend fun tierToCool(argument: suspend DateAfterCreationArgsBuilder.() -> Unit) {
        val toBeMapped = DateAfterCreationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tierToCool = mapped
    }

    /**
     * @param value The function to tier blobs to hot storage. This action can only be used with Premium Block Blob Storage Accounts
     */
    @JvmName("phjlgafhvxdxaity")
    public suspend fun tierToHot(`value`: DateAfterCreationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tierToHot = mapped
    }

    /**
     * @param argument The function to tier blobs to hot storage. This action can only be used with Premium Block Blob Storage Accounts
     */
    @JvmName("jarlmqvndaunqnns")
    public suspend fun tierToHot(argument: suspend DateAfterCreationArgsBuilder.() -> Unit) {
        val toBeMapped = DateAfterCreationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tierToHot = mapped
    }

    internal fun build(): ManagementPolicySnapShotArgs = ManagementPolicySnapShotArgs(
        delete = delete,
        tierToArchive = tierToArchive,
        tierToCold = tierToCold,
        tierToCool = tierToCool,
        tierToHot = tierToHot,
    )
}
