@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Filters limit replication to a subset of blobs within the storage account. A logical OR is performed on values in the filter. If multiple filters are defined, a logical AND is performed on all filters.
 * @property minCreationTime Blobs created after the time will be replicated to the destination. It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'. Example: 2020-02-19T16:05:00Z
 * @property prefixMatch Optional. Filters the results to replicate only blobs whose names begin with the specified prefix.
 */
public data class ObjectReplicationPolicyFilterArgs(
    public val minCreationTime: Output<String>? = null,
    public val prefixMatch: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyFilterArgs =
        com.pulumi.azurenative.storage.inputs.ObjectReplicationPolicyFilterArgs.builder()
            .minCreationTime(minCreationTime?.applyValue({ args0 -> args0 }))
            .prefixMatch(prefixMatch?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ObjectReplicationPolicyFilterArgs].
 */
@PulumiTagMarker
public class ObjectReplicationPolicyFilterArgsBuilder internal constructor() {
    private var minCreationTime: Output<String>? = null

    private var prefixMatch: Output<List<String>>? = null

    /**
     * @param value Blobs created after the time will be replicated to the destination. It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'. Example: 2020-02-19T16:05:00Z
     */
    @JvmName("mbnsnngeoeyvnpbj")
    public suspend fun minCreationTime(`value`: Output<String>) {
        this.minCreationTime = value
    }

    /**
     * @param value Optional. Filters the results to replicate only blobs whose names begin with the specified prefix.
     */
    @JvmName("cbqfoykklubbxemw")
    public suspend fun prefixMatch(`value`: Output<List<String>>) {
        this.prefixMatch = value
    }

    @JvmName("xdmmttbqdtoveweg")
    public suspend fun prefixMatch(vararg values: Output<String>) {
        this.prefixMatch = Output.all(values.asList())
    }

    /**
     * @param values Optional. Filters the results to replicate only blobs whose names begin with the specified prefix.
     */
    @JvmName("lowvvvctlsyopdau")
    public suspend fun prefixMatch(values: List<Output<String>>) {
        this.prefixMatch = Output.all(values)
    }

    /**
     * @param value Blobs created after the time will be replicated to the destination. It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'. Example: 2020-02-19T16:05:00Z
     */
    @JvmName("krfcueapbviquxuy")
    public suspend fun minCreationTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minCreationTime = mapped
    }

    /**
     * @param value Optional. Filters the results to replicate only blobs whose names begin with the specified prefix.
     */
    @JvmName("ikbshwqijhluxglw")
    public suspend fun prefixMatch(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixMatch = mapped
    }

    /**
     * @param values Optional. Filters the results to replicate only blobs whose names begin with the specified prefix.
     */
    @JvmName("rqtbraletipgqlit")
    public suspend fun prefixMatch(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixMatch = mapped
    }

    internal fun build(): ObjectReplicationPolicyFilterArgs = ObjectReplicationPolicyFilterArgs(
        minCreationTime = minCreationTime,
        prefixMatch = prefixMatch,
    )
}
