@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.PermissionScopeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property permissions The permissions for the local user. Possible values include: Read (r), Write (w), Delete (d), List (l), and Create (c).
 * @property resourceName The name of resource, normally the container name or the file share name, used by the local user.
 * @property service The service used by the local user, e.g. blob, file.
 */
public data class PermissionScopeArgs(
    public val permissions: Output<String>,
    public val resourceName: Output<String>,
    public val service: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.PermissionScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.PermissionScopeArgs =
        com.pulumi.azurenative.storage.inputs.PermissionScopeArgs.builder()
            .permissions(permissions.applyValue({ args0 -> args0 }))
            .resourceName(resourceName.applyValue({ args0 -> args0 }))
            .service(service.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PermissionScopeArgs].
 */
@PulumiTagMarker
public class PermissionScopeArgsBuilder internal constructor() {
    private var permissions: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var service: Output<String>? = null

    /**
     * @param value The permissions for the local user. Possible values include: Read (r), Write (w), Delete (d), List (l), and Create (c).
     */
    @JvmName("ntixcklllqbqixqw")
    public suspend fun permissions(`value`: Output<String>) {
        this.permissions = value
    }

    /**
     * @param value The name of resource, normally the container name or the file share name, used by the local user.
     */
    @JvmName("uospmfqimhblqmrn")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The service used by the local user, e.g. blob, file.
     */
    @JvmName("vuegcpjhhisjopot")
    public suspend fun service(`value`: Output<String>) {
        this.service = value
    }

    /**
     * @param value The permissions for the local user. Possible values include: Read (r), Write (w), Delete (d), List (l), and Create (c).
     */
    @JvmName("smrhwthsbkbahxib")
    public suspend fun permissions(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value The name of resource, normally the container name or the file share name, used by the local user.
     */
    @JvmName("ntkvdyihqyshqagp")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The service used by the local user, e.g. blob, file.
     */
    @JvmName("dfqffpllxbvpaorh")
    public suspend fun service(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.service = mapped
    }

    internal fun build(): PermissionScopeArgs = PermissionScopeArgs(
        permissions = permissions ?: throw PulumiNullFieldException("permissions"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        service = service ?: throw PulumiNullFieldException("service"),
    )
}
