@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ResourceAccessRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource Access Rule.
 * @property resourceId Resource Id
 * @property tenantId Tenant Id
 */
public data class ResourceAccessRuleArgs(
    public val resourceId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ResourceAccessRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ResourceAccessRuleArgs =
        com.pulumi.azurenative.storage.inputs.ResourceAccessRuleArgs.builder()
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceAccessRuleArgs].
 */
@PulumiTagMarker
public class ResourceAccessRuleArgsBuilder internal constructor() {
    private var resourceId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Resource Id
     */
    @JvmName("ptghixqbdixjupoi")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Tenant Id
     */
    @JvmName("fgvfseuqisquvsba")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Resource Id
     */
    @JvmName("iyskqjraflmdnohv")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Tenant Id
     */
    @JvmName("ofjojmngntddeqwk")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): ResourceAccessRuleArgs = ResourceAccessRuleArgs(
        resourceId = resourceId,
        tenantId = tenantId,
    )
}
