@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.SignedIdentifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accessPolicy Access policy
 * @property id An unique identifier of the stored access policy.
 */
public data class SignedIdentifierArgs(
    public val accessPolicy: Output<AccessPolicyArgs>? = null,
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.SignedIdentifierArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.SignedIdentifierArgs =
        com.pulumi.azurenative.storage.inputs.SignedIdentifierArgs.builder()
            .accessPolicy(accessPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SignedIdentifierArgs].
 */
@PulumiTagMarker
public class SignedIdentifierArgsBuilder internal constructor() {
    private var accessPolicy: Output<AccessPolicyArgs>? = null

    private var id: Output<String>? = null

    /**
     * @param value Access policy
     */
    @JvmName("whurotqosjacmpac")
    public suspend fun accessPolicy(`value`: Output<AccessPolicyArgs>) {
        this.accessPolicy = value
    }

    /**
     * @param value An unique identifier of the stored access policy.
     */
    @JvmName("ndnfismfqvomntpo")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Access policy
     */
    @JvmName("dujsniamehbwrtxb")
    public suspend fun accessPolicy(`value`: AccessPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicy = mapped
    }

    /**
     * @param argument Access policy
     */
    @JvmName("oufsqfpxpvwfocbr")
    public suspend fun accessPolicy(argument: suspend AccessPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = AccessPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessPolicy = mapped
    }

    /**
     * @param value An unique identifier of the stored access policy.
     */
    @JvmName("unpxfcrxvmrbciwq")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): SignedIdentifierArgs = SignedIdentifierArgs(
        accessPolicy = accessPolicy,
        id = id,
    )
}
