@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.SmbSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Setting for SMB protocol
 * @property authenticationMethods SMB authentication methods supported by server. Valid values are NTLMv2, Kerberos. Should be passed as a string with delimiter ';'.
 * @property channelEncryption SMB channel encryption supported by server. Valid values are AES-128-CCM, AES-128-GCM, AES-256-GCM. Should be passed as a string with delimiter ';'.
 * @property kerberosTicketEncryption Kerberos ticket encryption supported by server. Valid values are RC4-HMAC, AES-256. Should be passed as a string with delimiter ';'
 * @property multichannel Multichannel setting. Applies to Premium FileStorage only.
 * @property versions SMB protocol versions supported by server. Valid values are SMB2.1, SMB3.0, SMB3.1.1. Should be passed as a string with delimiter ';'.
 */
public data class SmbSettingArgs(
    public val authenticationMethods: Output<String>? = null,
    public val channelEncryption: Output<String>? = null,
    public val kerberosTicketEncryption: Output<String>? = null,
    public val multichannel: Output<MultichannelArgs>? = null,
    public val versions: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.SmbSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.SmbSettingArgs =
        com.pulumi.azurenative.storage.inputs.SmbSettingArgs.builder()
            .authenticationMethods(authenticationMethods?.applyValue({ args0 -> args0 }))
            .channelEncryption(channelEncryption?.applyValue({ args0 -> args0 }))
            .kerberosTicketEncryption(kerberosTicketEncryption?.applyValue({ args0 -> args0 }))
            .multichannel(multichannel?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .versions(versions?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SmbSettingArgs].
 */
@PulumiTagMarker
public class SmbSettingArgsBuilder internal constructor() {
    private var authenticationMethods: Output<String>? = null

    private var channelEncryption: Output<String>? = null

    private var kerberosTicketEncryption: Output<String>? = null

    private var multichannel: Output<MultichannelArgs>? = null

    private var versions: Output<String>? = null

    /**
     * @param value SMB authentication methods supported by server. Valid values are NTLMv2, Kerberos. Should be passed as a string with delimiter ';'.
     */
    @JvmName("airllnbnhihinovr")
    public suspend fun authenticationMethods(`value`: Output<String>) {
        this.authenticationMethods = value
    }

    /**
     * @param value SMB channel encryption supported by server. Valid values are AES-128-CCM, AES-128-GCM, AES-256-GCM. Should be passed as a string with delimiter ';'.
     */
    @JvmName("sedibiljhlnakuuj")
    public suspend fun channelEncryption(`value`: Output<String>) {
        this.channelEncryption = value
    }

    /**
     * @param value Kerberos ticket encryption supported by server. Valid values are RC4-HMAC, AES-256. Should be passed as a string with delimiter ';'
     */
    @JvmName("qgosrymgwqwcqebv")
    public suspend fun kerberosTicketEncryption(`value`: Output<String>) {
        this.kerberosTicketEncryption = value
    }

    /**
     * @param value Multichannel setting. Applies to Premium FileStorage only.
     */
    @JvmName("fpdxovxbbkwcekbe")
    public suspend fun multichannel(`value`: Output<MultichannelArgs>) {
        this.multichannel = value
    }

    /**
     * @param value SMB protocol versions supported by server. Valid values are SMB2.1, SMB3.0, SMB3.1.1. Should be passed as a string with delimiter ';'.
     */
    @JvmName("rvanfqsoohkwcywu")
    public suspend fun versions(`value`: Output<String>) {
        this.versions = value
    }

    /**
     * @param value SMB authentication methods supported by server. Valid values are NTLMv2, Kerberos. Should be passed as a string with delimiter ';'.
     */
    @JvmName("xccyxnntbnupumyi")
    public suspend fun authenticationMethods(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMethods = mapped
    }

    /**
     * @param value SMB channel encryption supported by server. Valid values are AES-128-CCM, AES-128-GCM, AES-256-GCM. Should be passed as a string with delimiter ';'.
     */
    @JvmName("cnajkwmglxeyifig")
    public suspend fun channelEncryption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelEncryption = mapped
    }

    /**
     * @param value Kerberos ticket encryption supported by server. Valid values are RC4-HMAC, AES-256. Should be passed as a string with delimiter ';'
     */
    @JvmName("otynakxxcrrqviuy")
    public suspend fun kerberosTicketEncryption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kerberosTicketEncryption = mapped
    }

    /**
     * @param value Multichannel setting. Applies to Premium FileStorage only.
     */
    @JvmName("cfhrfbuiskqjrgcv")
    public suspend fun multichannel(`value`: MultichannelArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multichannel = mapped
    }

    /**
     * @param argument Multichannel setting. Applies to Premium FileStorage only.
     */
    @JvmName("oahidrqrltpslptb")
    public suspend fun multichannel(argument: suspend MultichannelArgsBuilder.() -> Unit) {
        val toBeMapped = MultichannelArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.multichannel = mapped
    }

    /**
     * @param value SMB protocol versions supported by server. Valid values are SMB2.1, SMB3.0, SMB3.1.1. Should be passed as a string with delimiter ';'.
     */
    @JvmName("jttixygmphttnksw")
    public suspend fun versions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versions = mapped
    }

    internal fun build(): SmbSettingArgs = SmbSettingArgs(
        authenticationMethods = authenticationMethods,
        channelEncryption = channelEncryption,
        kerberosTicketEncryption = kerberosTicketEncryption,
        multichannel = multichannel,
        versions = versions,
    )
}
