@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.TableSignedIdentifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Object to set Table Access Policy.
 * @property accessPolicy Access policy
 * @property id unique-64-character-value of the stored access policy.
 */
public data class TableSignedIdentifierArgs(
    public val accessPolicy: Output<TableAccessPolicyArgs>? = null,
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.TableSignedIdentifierArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.TableSignedIdentifierArgs =
        com.pulumi.azurenative.storage.inputs.TableSignedIdentifierArgs.builder()
            .accessPolicy(accessPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableSignedIdentifierArgs].
 */
@PulumiTagMarker
public class TableSignedIdentifierArgsBuilder internal constructor() {
    private var accessPolicy: Output<TableAccessPolicyArgs>? = null

    private var id: Output<String>? = null

    /**
     * @param value Access policy
     */
    @JvmName("rsfkthmbdaumcxqn")
    public suspend fun accessPolicy(`value`: Output<TableAccessPolicyArgs>) {
        this.accessPolicy = value
    }

    /**
     * @param value unique-64-character-value of the stored access policy.
     */
    @JvmName("tgtrdeakcjurensh")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Access policy
     */
    @JvmName("swdurpejkjtxbmkm")
    public suspend fun accessPolicy(`value`: TableAccessPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicy = mapped
    }

    /**
     * @param argument Access policy
     */
    @JvmName("jhjidgwcvpkweeed")
    public suspend fun accessPolicy(argument: suspend TableAccessPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = TableAccessPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessPolicy = mapped
    }

    /**
     * @param value unique-64-character-value of the stored access policy.
     */
    @JvmName("gjwnxaasmtprnhnq")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): TableSignedIdentifierArgs = TableSignedIdentifierArgs(
        accessPolicy = accessPolicy,
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
