@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.TagFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Blob index tag based filtering for blob objects
 * @property name This is the filter tag name, it can have 1 - 128 characters
 * @property op This is the comparison operator which is used for object comparison and filtering. Only == (equality operator) is currently supported
 * @property value This is the filter tag value field used for tag based filtering, it can have 0 - 256 characters
 */
public data class TagFilterArgs(
    public val name: Output<String>,
    public val op: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.TagFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.TagFilterArgs =
        com.pulumi.azurenative.storage.inputs.TagFilterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .op(op.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagFilterArgs].
 */
@PulumiTagMarker
public class TagFilterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var op: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value This is the filter tag name, it can have 1 - 128 characters
     */
    @JvmName("xdypgetmwuwyofmb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value This is the comparison operator which is used for object comparison and filtering. Only == (equality operator) is currently supported
     */
    @JvmName("bwdekmyavorpdkjd")
    public suspend fun op(`value`: Output<String>) {
        this.op = value
    }

    /**
     * @param value This is the filter tag value field used for tag based filtering, it can have 0 - 256 characters
     */
    @JvmName("wgsxkabotiwhljbn")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value This is the filter tag name, it can have 1 - 128 characters
     */
    @JvmName("rwfcfnftgrsptqnk")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value This is the comparison operator which is used for object comparison and filtering. Only == (equality operator) is currently supported
     */
    @JvmName("yknlkbxwyabogcuj")
    public suspend fun op(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.op = mapped
    }

    /**
     * @param value This is the filter tag value field used for tag based filtering, it can have 0 - 256 characters
     */
    @JvmName("skcalldtljahnewx")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TagFilterArgs = TagFilterArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        op = op ?: throw PulumiNullFieldException("op"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
