@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * This defines account-level immutability policy properties.
 * @property allowProtectedAppendWrites This property can only be changed for disabled and unlocked time-based retention policies. When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
 * @property immutabilityPeriodSinceCreationInDays The immutability period for the blobs in the container since the policy creation, in days.
 * @property state The ImmutabilityPolicy state defines the mode of the policy. Disabled state disables the policy, Unlocked state allows increase and decrease of immutability retention time and also allows toggling allowProtectedAppendWrites property, Locked state only allows the increase of the immutability retention time. A policy can only be created in a Disabled or Unlocked state and can be toggled between the two states. Only a policy in an Unlocked state can transition to a Locked state which cannot be reverted.
 */
public data class AccountImmutabilityPolicyPropertiesResponse(
    public val allowProtectedAppendWrites: Boolean? = null,
    public val immutabilityPeriodSinceCreationInDays: Int? = null,
    public val state: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.AccountImmutabilityPolicyPropertiesResponse):
            AccountImmutabilityPolicyPropertiesResponse = AccountImmutabilityPolicyPropertiesResponse(
            allowProtectedAppendWrites = javaType.allowProtectedAppendWrites().map({ args0 ->
                args0
            }).orElse(null),
            immutabilityPeriodSinceCreationInDays = javaType.immutabilityPeriodSinceCreationInDays().map({ args0 ->
                args0
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
