@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Settings properties for Active Directory (AD).
 * @property accountType Specifies the Active Directory account type for Azure Storage.
 * @property azureStorageSid Specifies the security identifier (SID) for Azure Storage.
 * @property domainGuid Specifies the domain GUID.
 * @property domainName Specifies the primary domain that the AD DNS server is authoritative for.
 * @property domainSid Specifies the security identifier (SID).
 * @property forestName Specifies the Active Directory forest to get.
 * @property netBiosDomainName Specifies the NetBIOS domain name.
 * @property samAccountName Specifies the Active Directory SAMAccountName for Azure Storage.
 */
public data class ActiveDirectoryPropertiesResponse(
    public val accountType: String? = null,
    public val azureStorageSid: String? = null,
    public val domainGuid: String,
    public val domainName: String,
    public val domainSid: String? = null,
    public val forestName: String? = null,
    public val netBiosDomainName: String? = null,
    public val samAccountName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ActiveDirectoryPropertiesResponse):
            ActiveDirectoryPropertiesResponse = ActiveDirectoryPropertiesResponse(
            accountType = javaType.accountType().map({ args0 -> args0 }).orElse(null),
            azureStorageSid = javaType.azureStorageSid().map({ args0 -> args0 }).orElse(null),
            domainGuid = javaType.domainGuid(),
            domainName = javaType.domainName(),
            domainSid = javaType.domainSid().map({ args0 -> args0 }).orElse(null),
            forestName = javaType.forestName().map({ args0 -> args0 }).orElse(null),
            netBiosDomainName = javaType.netBiosDomainName().map({ args0 -> args0 }).orElse(null),
            samAccountName = javaType.samAccountName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
