@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Blob restore parameters
 * @property blobRanges Blob ranges to restore.
 * @property timeToRestore Restore blob to the specified time.
 */
public data class BlobRestoreParametersResponse(
    public val blobRanges: List<BlobRestoreRangeResponse>,
    public val timeToRestore: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.BlobRestoreParametersResponse):
            BlobRestoreParametersResponse = BlobRestoreParametersResponse(
            blobRanges = javaType.blobRanges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.BlobRestoreRangeResponse.Companion.toKotlin(args0)
                })
            }),
            timeToRestore = javaType.timeToRestore(),
        )
    }
}
