@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * Object to define the base blob action conditions. Properties daysAfterModificationGreaterThan, daysAfterLastAccessTimeGreaterThan and daysAfterCreationGreaterThan are mutually exclusive. The daysAfterLastTierChangeGreaterThan property is only applicable for tierToArchive actions which requires daysAfterModificationGreaterThan to be set, also it cannot be used in conjunction with daysAfterLastAccessTimeGreaterThan or daysAfterCreationGreaterThan.
 * @property daysAfterCreationGreaterThan Value indicating the age in days after blob creation.
 * @property daysAfterLastAccessTimeGreaterThan Value indicating the age in days after last blob access. This property can only be used in conjunction with last access time tracking policy
 * @property daysAfterLastTierChangeGreaterThan Value indicating the age in days after last blob tier change time. This property is only applicable for tierToArchive actions and requires daysAfterModificationGreaterThan to be set for baseBlobs based actions. The blob will be archived if both the conditions are satisfied.
 * @property daysAfterModificationGreaterThan Value indicating the age in days after last modification
 */
public data class DateAfterModificationResponse(
    public val daysAfterCreationGreaterThan: Double? = null,
    public val daysAfterLastAccessTimeGreaterThan: Double? = null,
    public val daysAfterLastTierChangeGreaterThan: Double? = null,
    public val daysAfterModificationGreaterThan: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.DateAfterModificationResponse):
            DateAfterModificationResponse = DateAfterModificationResponse(
            daysAfterCreationGreaterThan = javaType.daysAfterCreationGreaterThan().map({ args0 ->
                args0
            }).orElse(null),
            daysAfterLastAccessTimeGreaterThan = javaType.daysAfterLastAccessTimeGreaterThan().map({ args0 ->
                args0
            }).orElse(null),
            daysAfterLastTierChangeGreaterThan = javaType.daysAfterLastTierChangeGreaterThan().map({ args0 ->
                args0
            }).orElse(null),
            daysAfterModificationGreaterThan = javaType.daysAfterModificationGreaterThan().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
