@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The local user associated with the storage accounts.
 * @property hasSharedKey Indicates whether shared key exists. Set it to false to remove existing shared key.
 * @property hasSshKey Indicates whether ssh key exists. Set it to false to remove existing SSH key.
 * @property hasSshPassword Indicates whether ssh password exists. Set it to false to remove existing SSH password.
 * @property homeDirectory Optional, local user home directory.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property permissionScopes The permission scopes of the local user.
 * @property sid A unique Security Identifier that is generated by the server.
 * @property sshAuthorizedKeys Optional, local user ssh authorized keys for SFTP.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetLocalUserResult(
    public val hasSharedKey: Boolean? = null,
    public val hasSshKey: Boolean? = null,
    public val hasSshPassword: Boolean? = null,
    public val homeDirectory: String? = null,
    public val id: String,
    public val name: String,
    public val permissionScopes: List<PermissionScopeResponse>? = null,
    public val sid: String,
    public val sshAuthorizedKeys: List<SshPublicKeyResponse>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.GetLocalUserResult):
            GetLocalUserResult = GetLocalUserResult(
            hasSharedKey = javaType.hasSharedKey().map({ args0 -> args0 }).orElse(null),
            hasSshKey = javaType.hasSshKey().map({ args0 -> args0 }).orElse(null),
            hasSshPassword = javaType.hasSshPassword().map({ args0 -> args0 }).orElse(null),
            homeDirectory = javaType.homeDirectory().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            permissionScopes = javaType.permissionScopes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.PermissionScopeResponse.Companion.toKotlin(args0)
                })
            }),
            sid = javaType.sid(),
            sshAuthorizedKeys = javaType.sshAuthorizedKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.SshPublicKeyResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
