@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of the table, including Id, resource name, resource type.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property signedIdentifiers List of stored access policies specified on the table.
 * @property tableName Table name under the specified account
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetTableResult(
    public val id: String,
    public val name: String,
    public val signedIdentifiers: List<TableSignedIdentifierResponse>? = null,
    public val tableName: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.GetTableResult):
            GetTableResult = GetTableResult(
            id = javaType.id(),
            name = javaType.name(),
            signedIdentifiers = javaType.signedIdentifiers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.TableSignedIdentifierResponse.Companion.toKotlin(args0)
                })
            }),
            tableName = javaType.tableName(),
            type = javaType.type(),
        )
    }
}
