@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * An object that wraps the Lifecycle rule. Each rule is uniquely defined by name.
 * @property definition An object that defines the Lifecycle rule.
 * @property enabled Rule is enabled if set to true.
 * @property name A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be unique within a policy.
 * @property type The valid value is Lifecycle
 */
public data class ManagementPolicyRuleResponse(
    public val definition: ManagementPolicyDefinitionResponse,
    public val enabled: Boolean? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ManagementPolicyRuleResponse):
            ManagementPolicyRuleResponse = ManagementPolicyRuleResponse(
            definition = javaType.definition().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.ManagementPolicyDefinitionResponse.Companion.toKotlin(args0)
            }),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
