@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resource Access Rule.
 * @property resourceId Resource Id
 * @property tenantId Tenant Id
 */
public data class ResourceAccessRuleResponse(
    public val resourceId: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.ResourceAccessRuleResponse):
            ResourceAccessRuleResponse = ResourceAccessRuleResponse(
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
