@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The blob service properties for blob restore policy
 * @property days how long this blob can be restored. It should be great than zero and less than DeleteRetentionPolicy.days.
 * @property enabled Blob restore is enabled if set to true.
 * @property lastEnabledTime Deprecated in favor of minRestoreTime property.
 * @property minRestoreTime Returns the minimum date and time that the restore can be started.
 */
public data class RestorePolicyPropertiesResponse(
    public val days: Int? = null,
    public val enabled: Boolean,
    public val lastEnabledTime: String,
    public val minRestoreTime: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.RestorePolicyPropertiesResponse):
            RestorePolicyPropertiesResponse = RestorePolicyPropertiesResponse(
            days = javaType.days().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled(),
            lastEnabledTime = javaType.lastEnabledTime(),
            minRestoreTime = javaType.minRestoreTime(),
        )
    }
}
