@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The SKU of the storage account.
 * @property name The SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called accountType.
 * @property tier The SKU tier. This is based on the SKU name.
 */
public data class SkuResponse(
    public val name: String,
    public val tier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.SkuResponse): SkuResponse =
            SkuResponse(
                name = javaType.name(),
                tier = javaType.tier(),
            )
    }
}
