@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * UserAssignedIdentity for the resource.
 * @property clientId The client ID of the identity.
 * @property principalId The principal ID of the identity.
 */
public data class UserAssignedIdentityResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.UserAssignedIdentityResponse):
            UserAssignedIdentityResponse = UserAssignedIdentityResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
