@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storageactions.kotlin.inputs

import com.pulumi.azurenative.storageactions.inputs.ElseConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The else block of storage task operation
 * @property operations List of operations to execute in the else block
 */
public data class ElseConditionArgs(
    public val operations: Output<List<StorageTaskOperationArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.storageactions.inputs.ElseConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.storageactions.inputs.ElseConditionArgs =
        com.pulumi.azurenative.storageactions.inputs.ElseConditionArgs.builder()
            .operations(
                operations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ElseConditionArgs].
 */
@PulumiTagMarker
public class ElseConditionArgsBuilder internal constructor() {
    private var operations: Output<List<StorageTaskOperationArgs>>? = null

    /**
     * @param value List of operations to execute in the else block
     */
    @JvmName("eitfpmxxenolguvm")
    public suspend fun operations(`value`: Output<List<StorageTaskOperationArgs>>) {
        this.operations = value
    }

    @JvmName("woovmsayuyuvceyd")
    public suspend fun operations(vararg values: Output<StorageTaskOperationArgs>) {
        this.operations = Output.all(values.asList())
    }

    /**
     * @param values List of operations to execute in the else block
     */
    @JvmName("fvtaisdyymtceumt")
    public suspend fun operations(values: List<Output<StorageTaskOperationArgs>>) {
        this.operations = Output.all(values)
    }

    /**
     * @param value List of operations to execute in the else block
     */
    @JvmName("whqvweearqkthwub")
    public suspend fun operations(`value`: List<StorageTaskOperationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operations = mapped
    }

    /**
     * @param argument List of operations to execute in the else block
     */
    @JvmName("ohfsdfysihojsmyd")
    public suspend
    fun operations(argument: List<suspend StorageTaskOperationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageTaskOperationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.operations = mapped
    }

    /**
     * @param argument List of operations to execute in the else block
     */
    @JvmName("wksbiahdoayqbcxt")
    public suspend fun operations(
        vararg
        argument: suspend StorageTaskOperationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StorageTaskOperationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.operations = mapped
    }

    /**
     * @param argument List of operations to execute in the else block
     */
    @JvmName("xjpvchcgrdgnntdw")
    public suspend fun operations(argument: suspend StorageTaskOperationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StorageTaskOperationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.operations = mapped
    }

    /**
     * @param values List of operations to execute in the else block
     */
    @JvmName("xsckwpqxilnrlpjc")
    public suspend fun operations(vararg values: StorageTaskOperationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operations = mapped
    }

    internal fun build(): ElseConditionArgs = ElseConditionArgs(
        operations = operations ?: throw PulumiNullFieldException("operations"),
    )
}
