@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storageactions.kotlin.inputs

import com.pulumi.azurenative.storageactions.inputs.StorageTaskOperationArgs.builder
import com.pulumi.azurenative.storageactions.kotlin.enums.OnFailure
import com.pulumi.azurenative.storageactions.kotlin.enums.OnSuccess
import com.pulumi.azurenative.storageactions.kotlin.enums.StorageTaskOperationName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents an operation to be performed on the object
 * @property name The operation to be performed on the object.
 * @property onFailure Action to be taken when the operation fails for a object.
 * @property onSuccess Action to be taken when the operation is successful for a object.
 * @property parameters Key-value parameters for the operation.
 */
public data class StorageTaskOperationArgs(
    public val name: Output<Either<String, StorageTaskOperationName>>,
    public val onFailure: Output<OnFailure>? = null,
    public val onSuccess: Output<OnSuccess>? = null,
    public val parameters: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storageactions.inputs.StorageTaskOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.storageactions.inputs.StorageTaskOperationArgs =
        com.pulumi.azurenative.storageactions.inputs.StorageTaskOperationArgs.builder()
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .onFailure(onFailure?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .onSuccess(onSuccess?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StorageTaskOperationArgs].
 */
@PulumiTagMarker
public class StorageTaskOperationArgsBuilder internal constructor() {
    private var name: Output<Either<String, StorageTaskOperationName>>? = null

    private var onFailure: Output<OnFailure>? = null

    private var onSuccess: Output<OnSuccess>? = null

    private var parameters: Output<Map<String, String>>? = null

    /**
     * @param value The operation to be performed on the object.
     */
    @JvmName("mrcbsgiehesllveb")
    public suspend fun name(`value`: Output<Either<String, StorageTaskOperationName>>) {
        this.name = value
    }

    /**
     * @param value Action to be taken when the operation fails for a object.
     */
    @JvmName("ycslyoueyjgergol")
    public suspend fun onFailure(`value`: Output<OnFailure>) {
        this.onFailure = value
    }

    /**
     * @param value Action to be taken when the operation is successful for a object.
     */
    @JvmName("oddiuiltartjcdhe")
    public suspend fun onSuccess(`value`: Output<OnSuccess>) {
        this.onSuccess = value
    }

    /**
     * @param value Key-value parameters for the operation.
     */
    @JvmName("ooudmxdbrphlcxsj")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value The operation to be performed on the object.
     */
    @JvmName("dyigntwstmynfnit")
    public suspend fun name(`value`: Either<String, StorageTaskOperationName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The operation to be performed on the object.
     */
    @JvmName("dqecrltquymggxbb")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageTaskOperationName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The operation to be performed on the object.
     */
    @JvmName("uvmlyrxpatmhemmv")
    public fun name(`value`: StorageTaskOperationName) {
        val toBeMapped = Either.ofRight<String, StorageTaskOperationName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Action to be taken when the operation fails for a object.
     */
    @JvmName("xmgmmhvthnvfqkvn")
    public suspend fun onFailure(`value`: OnFailure?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onFailure = mapped
    }

    /**
     * @param value Action to be taken when the operation is successful for a object.
     */
    @JvmName("estrahpipmohlema")
    public suspend fun onSuccess(`value`: OnSuccess?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onSuccess = mapped
    }

    /**
     * @param value Key-value parameters for the operation.
     */
    @JvmName("jcanpyanudsmigiu")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Key-value parameters for the operation.
     */
    @JvmName("mmacbjthfkevykup")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): StorageTaskOperationArgs = StorageTaskOperationArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        onFailure = onFailure,
        onSuccess = onSuccess,
        parameters = parameters,
    )
}
