@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storageactions.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The if block of storage task operation
 * @property condition The condition predicate which is composed of object properties, eg: blob and container properties.
 * @property operations List of operations to execute when the condition predicate satisfies.
 */
public data class IfConditionResponse(
    public val condition: String,
    public val operations: List<StorageTaskOperationResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storageactions.outputs.IfConditionResponse):
            IfConditionResponse = IfConditionResponse(
            condition = javaType.condition(),
            operations = javaType.operations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storageactions.kotlin.outputs.StorageTaskOperationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
