@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of the Storage Target.
 */
public enum class StorageTargetType(
    public val javaValue: com.pulumi.azurenative.storagecache.enums.StorageTargetType,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.enums.StorageTargetType> {
    Nfs3(com.pulumi.azurenative.storagecache.enums.StorageTargetType.Nfs3),
    Clfs(com.pulumi.azurenative.storagecache.enums.StorageTargetType.Clfs),
    Unknown(com.pulumi.azurenative.storagecache.enums.StorageTargetType.Unknown),
    BlobNfs(com.pulumi.azurenative.storagecache.enums.StorageTargetType.BlobNfs),
    ;

    override fun toJava(): com.pulumi.azurenative.storagecache.enums.StorageTargetType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.enums.StorageTargetType):
            StorageTargetType = StorageTargetType.values().first { it.javaValue == javaType }
    }
}
