@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.CacheUpgradeSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cache Upgrade Settings.
 * @property scheduledTime When upgradeScheduleEnabled is true, this field holds the user-chosen upgrade time. At the user-chosen time, the firmware update will automatically be installed on the cache.
 * @property upgradeScheduleEnabled True if the user chooses to select an installation time between now and firmwareUpdateDeadline. Else the firmware will automatically be installed after firmwareUpdateDeadline if not triggered earlier via the upgrade operation.
 */
public data class CacheUpgradeSettingsArgs(
    public val scheduledTime: Output<String>? = null,
    public val upgradeScheduleEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.CacheUpgradeSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.CacheUpgradeSettingsArgs =
        com.pulumi.azurenative.storagecache.inputs.CacheUpgradeSettingsArgs.builder()
            .scheduledTime(scheduledTime?.applyValue({ args0 -> args0 }))
            .upgradeScheduleEnabled(upgradeScheduleEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CacheUpgradeSettingsArgs].
 */
@PulumiTagMarker
public class CacheUpgradeSettingsArgsBuilder internal constructor() {
    private var scheduledTime: Output<String>? = null

    private var upgradeScheduleEnabled: Output<Boolean>? = null

    /**
     * @param value When upgradeScheduleEnabled is true, this field holds the user-chosen upgrade time. At the user-chosen time, the firmware update will automatically be installed on the cache.
     */
    @JvmName("qedrlrhholvevkpc")
    public suspend fun scheduledTime(`value`: Output<String>) {
        this.scheduledTime = value
    }

    /**
     * @param value True if the user chooses to select an installation time between now and firmwareUpdateDeadline. Else the firmware will automatically be installed after firmwareUpdateDeadline if not triggered earlier via the upgrade operation.
     */
    @JvmName("gpfpyucxndvxomdc")
    public suspend fun upgradeScheduleEnabled(`value`: Output<Boolean>) {
        this.upgradeScheduleEnabled = value
    }

    /**
     * @param value When upgradeScheduleEnabled is true, this field holds the user-chosen upgrade time. At the user-chosen time, the firmware update will automatically be installed on the cache.
     */
    @JvmName("bncdgykweqlknpcq")
    public suspend fun scheduledTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduledTime = mapped
    }

    /**
     * @param value True if the user chooses to select an installation time between now and firmwareUpdateDeadline. Else the firmware will automatically be installed after firmwareUpdateDeadline if not triggered earlier via the upgrade operation.
     */
    @JvmName("buoqaaanagwakumu")
    public suspend fun upgradeScheduleEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradeScheduleEnabled = mapped
    }

    internal fun build(): CacheUpgradeSettingsArgs = CacheUpgradeSettingsArgs(
        scheduledTime = scheduledTime,
        upgradeScheduleEnabled = upgradeScheduleEnabled,
    )
}
