@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.GetAmlFilesystemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property amlFilesystemName Name for the AML file system. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAmlFilesystemPlainArgs(
    public val amlFilesystemName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.GetAmlFilesystemPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.GetAmlFilesystemPlainArgs =
        com.pulumi.azurenative.storagecache.inputs.GetAmlFilesystemPlainArgs.builder()
            .amlFilesystemName(amlFilesystemName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAmlFilesystemPlainArgs].
 */
@PulumiTagMarker
public class GetAmlFilesystemPlainArgsBuilder internal constructor() {
    private var amlFilesystemName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name for the AML file system. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric.
     */
    @JvmName("faopclerbfxwxrbm")
    public suspend fun amlFilesystemName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.amlFilesystemName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pjcammqaqlelferr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAmlFilesystemPlainArgs = GetAmlFilesystemPlainArgs(
        amlFilesystemName = amlFilesystemName ?: throw PulumiNullFieldException("amlFilesystemName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
