@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.NfsAccessPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A set of rules describing access policies applied to NFSv3 clients of the cache.
 * @property accessRules The set of rules describing client accesses allowed under this policy.
 * @property name Name identifying this policy. Access Policy names are not case sensitive.
 */
public data class NfsAccessPolicyArgs(
    public val accessRules: Output<List<NfsAccessRuleArgs>>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.NfsAccessPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.NfsAccessPolicyArgs =
        com.pulumi.azurenative.storagecache.inputs.NfsAccessPolicyArgs.builder()
            .accessRules(
                accessRules.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NfsAccessPolicyArgs].
 */
@PulumiTagMarker
public class NfsAccessPolicyArgsBuilder internal constructor() {
    private var accessRules: Output<List<NfsAccessRuleArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value The set of rules describing client accesses allowed under this policy.
     */
    @JvmName("sfudrjiwxghgjuia")
    public suspend fun accessRules(`value`: Output<List<NfsAccessRuleArgs>>) {
        this.accessRules = value
    }

    @JvmName("ljnhsxknbkmnqcqi")
    public suspend fun accessRules(vararg values: Output<NfsAccessRuleArgs>) {
        this.accessRules = Output.all(values.asList())
    }

    /**
     * @param values The set of rules describing client accesses allowed under this policy.
     */
    @JvmName("hqifsxtoliekomad")
    public suspend fun accessRules(values: List<Output<NfsAccessRuleArgs>>) {
        this.accessRules = Output.all(values)
    }

    /**
     * @param value Name identifying this policy. Access Policy names are not case sensitive.
     */
    @JvmName("cjiwlldklmtfcdjf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The set of rules describing client accesses allowed under this policy.
     */
    @JvmName("tfprxsfyaspwtepd")
    public suspend fun accessRules(`value`: List<NfsAccessRuleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessRules = mapped
    }

    /**
     * @param argument The set of rules describing client accesses allowed under this policy.
     */
    @JvmName("krliddfjqfcypvod")
    public suspend fun accessRules(argument: List<suspend NfsAccessRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NfsAccessRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.accessRules = mapped
    }

    /**
     * @param argument The set of rules describing client accesses allowed under this policy.
     */
    @JvmName("keroifddsugqnqdh")
    public suspend fun accessRules(vararg argument: suspend NfsAccessRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NfsAccessRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.accessRules = mapped
    }

    /**
     * @param argument The set of rules describing client accesses allowed under this policy.
     */
    @JvmName("lrfncgswsxomecaw")
    public suspend fun accessRules(argument: suspend NfsAccessRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NfsAccessRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.accessRules = mapped
    }

    /**
     * @param values The set of rules describing client accesses allowed under this policy.
     */
    @JvmName("bmmqpcrjwffuohfk")
    public suspend fun accessRules(vararg values: NfsAccessRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessRules = mapped
    }

    /**
     * @param value Name identifying this policy. Access Policy names are not case sensitive.
     */
    @JvmName("yxkfoqtbjutwkhci")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): NfsAccessPolicyArgs = NfsAccessPolicyArgs(
        accessRules = accessRules ?: throw PulumiNullFieldException("accessRules"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
