@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.SkuName.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU for the resource.
 * @property name SKU name for this resource.
 */
public data class SkuName(
    public val name: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.SkuName> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.SkuName =
        com.pulumi.azurenative.storagecache.inputs.SkuName.builder()
            .name(name?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuName].
 */
@PulumiTagMarker
public class SkuNameBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value SKU name for this resource.
     */
    @JvmName("giuvalpypyeivfjs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): SkuName = SkuName(
        name = name,
    )
}
