@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.SkuNameArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU for the resource.
 * @property name SKU name for this resource.
 */
public data class SkuNameArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.SkuNameArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.SkuNameArgs =
        com.pulumi.azurenative.storagecache.inputs.SkuNameArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuNameArgs].
 */
@PulumiTagMarker
public class SkuNameArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value SKU name for this resource.
     */
    @JvmName("qypfgujxvkyfbpen")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value SKU name for this resource.
     */
    @JvmName("ahofkekxihvlrrwd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SkuNameArgs = SkuNameArgs(
        name = name,
    )
}
