@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.UnknownTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties pertaining to the UnknownTarget
 * @property attributes Dictionary of string->string pairs containing information about the Storage Target.
 */
public data class UnknownTargetArgs(
    public val attributes: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.UnknownTargetArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.UnknownTargetArgs =
        com.pulumi.azurenative.storagecache.inputs.UnknownTargetArgs.builder()
            .attributes(
                attributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [UnknownTargetArgs].
 */
@PulumiTagMarker
public class UnknownTargetArgsBuilder internal constructor() {
    private var attributes: Output<Map<String, String>>? = null

    /**
     * @param value Dictionary of string->string pairs containing information about the Storage Target.
     */
    @JvmName("ndqsacwskxsrfcmo")
    public suspend fun attributes(`value`: Output<Map<String, String>>) {
        this.attributes = value
    }

    /**
     * @param value Dictionary of string->string pairs containing information about the Storage Target.
     */
    @JvmName("yvbdohajsqduryjl")
    public suspend fun attributes(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param values Dictionary of string->string pairs containing information about the Storage Target.
     */
    @JvmName("kjvhtrtejxjpfoyy")
    public fun attributes(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    internal fun build(): UnknownTargetArgs = UnknownTargetArgs(
        attributes = attributes,
    )
}
