@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Active Directory settings used to join a cache to a domain.
 * @property cacheNetBiosName The NetBIOS name to assign to the HPC Cache when it joins the Active Directory domain as a server. Length must 1-15 characters from the class [-0-9a-zA-Z].
 * @property credentials Active Directory admin credentials used to join the HPC Cache to a domain.
 * @property domainJoined True if the HPC Cache is joined to the Active Directory domain.
 * @property domainName The fully qualified domain name of the Active Directory domain controller.
 * @property domainNetBiosName The Active Directory domain's NetBIOS name.
 * @property primaryDnsIpAddress Primary DNS IP address used to resolve the Active Directory domain controller's fully qualified domain name.
 * @property secondaryDnsIpAddress Secondary DNS IP address used to resolve the Active Directory domain controller's fully qualified domain name.
 */
public data class CacheActiveDirectorySettingsResponse(
    public val cacheNetBiosName: String,
    public val credentials: CacheActiveDirectorySettingsResponseCredentials? = null,
    public val domainJoined: String,
    public val domainName: String,
    public val domainNetBiosName: String,
    public val primaryDnsIpAddress: String,
    public val secondaryDnsIpAddress: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.CacheActiveDirectorySettingsResponse):
            CacheActiveDirectorySettingsResponse = CacheActiveDirectorySettingsResponse(
            cacheNetBiosName = javaType.cacheNetBiosName(),
            credentials = javaType.credentials().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.CacheActiveDirectorySettingsResponseCredentials.Companion.toKotlin(args0)
                })
            }).orElse(null),
            domainJoined = javaType.domainJoined(),
            domainName = javaType.domainName(),
            domainNetBiosName = javaType.domainNetBiosName(),
            primaryDnsIpAddress = javaType.primaryDnsIpAddress(),
            secondaryDnsIpAddress = javaType.secondaryDnsIpAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
